/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.ogl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.ogl.GlCanvas;
import edu.mines.jtk.ogl.TestSimple;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Direct;
import edu.mines.jtk.util.Stopwatch;
import java.nio.FloatBuffer;
import java.util.Random;

public class QuadTest {
    private static GlCanvas canvas = new GlCanvas(){
        private int _nq;
        private FloatBuffer _vb;
        private FloatBuffer _nb;
        private FloatBuffer _cb;
        private Stopwatch _stopwatch = new Stopwatch();
        private int _npaint;
        private double _zoom = 1.0;

        @Override
        public void glInit() {
            this.makeQuads(65536);
            Gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            Gl.glEnable(2929);
            this._stopwatch.start();
        }

        @Override
        public void glResize(int x, int y, int width, int height) {
            Gl.glViewport(0, 0, width, height);
            Gl.glMatrixMode(5889);
            Gl.glLoadIdentity();
            Gl.glFrustum(-0.03, 0.03, -0.03, 0.03, 0.1, 100.0);
            this.setModelView(this._zoom);
        }

        private void setModelView(double zoom) {
            this._zoom = zoom;
            Gl.glMatrixMode(5888);
            Gl.glLoadIdentity();
            Gl.glTranslated(0.0, 0.0, -4.0 / this._zoom);
            Gl.glRotated(-80.0, 1.0, 0.0, 0.0);
        }

        @Override
        public void glPaint() {
            Gl.glClear(16640);
            Gl.glEnableClientState(32884);
            Gl.glEnableClientState(32885);
            Gl.glEnableClientState(32886);
            Gl.glVertexPointer(3, 5126, 0, this._vb);
            Gl.glNormalPointer(5126, 0, this._nb);
            Gl.glColorPointer(3, 5126, 0, this._cb);
            Gl.glDrawArrays(7, 0, 4 * this._nq);
            Gl.glDisableClientState(32885);
            Gl.glDisableClientState(32886);
            Gl.glDisableClientState(32884);
            Gl.glRotated(1.0, 0.0, 0.0, 1.0);
            Gl.glFlush();
            ++this._npaint;
            if (this._stopwatch.time() > 2.0) {
                this._stopwatch.stop();
                float fps = (float)((double)this._npaint / this._stopwatch.time());
                int qps = (int)((float)this._nq * fps);
                System.out.println("frames/second = " + fps + ", quads/second = " + qps);
                this._npaint = 0;
                if (this._zoom < 16.0) {
                    this.setModelView(2.0 * this._zoom);
                } else {
                    this.setModelView(0.0625);
                }
                if (fps < 29.0f) {
                    this.makeQuads(this._nq / 2);
                } else if (fps > 59.0f) {
                    this.makeQuads(this._nq * 2);
                }
                this._stopwatch.restart();
            }
        }

        private void makeQuads(int nq) {
            System.out.println("quads/frame = " + nq);
            this._nq = nq;
            int nv = 4 * nq;
            int nn = 4 * nq;
            int nc = 4 * nq;
            Random random = new Random();
            this._vb = Direct.newFloatBuffer(3 * nv);
            this._nb = Direct.newFloatBuffer(3 * nn);
            this._cb = Direct.newFloatBuffer(3 * nc);
            float e = 0.01f;
            int iv = 0;
            int in = 0;
            int ic = 0;
            for (int iq = 0; iq < nq; ++iq) {
                float radius = 1.0f + 0.1f * random.nextFloat();
                float r = random.nextFloat();
                float g = random.nextFloat();
                float b = random.nextFloat();
                float p = (float)Math.PI * random.nextFloat() * 2.0f;
                float t = (float)Math.PI * random.nextFloat();
                float u = ArrayMath.sin(p) * ArrayMath.cos(t);
                float v = ArrayMath.sin(p) * ArrayMath.sin(t);
                float w = ArrayMath.cos(p);
                this._vb.put(iv++, radius * ArrayMath.cos(p - e) * ArrayMath.cos(t - e));
                this._vb.put(iv++, radius * ArrayMath.cos(p - e) * ArrayMath.sin(t - e));
                this._vb.put(iv++, radius * ArrayMath.sin(p - e));
                this._vb.put(iv++, radius * ArrayMath.cos(p + e) * ArrayMath.cos(t - e));
                this._vb.put(iv++, radius * ArrayMath.cos(p + e) * ArrayMath.sin(t - e));
                this._vb.put(iv++, radius * ArrayMath.sin(p + e));
                this._vb.put(iv++, radius * ArrayMath.cos(p + e) * ArrayMath.cos(t + e));
                this._vb.put(iv++, radius * ArrayMath.cos(p + e) * ArrayMath.sin(t + e));
                this._vb.put(iv++, radius * ArrayMath.sin(p + e));
                this._vb.put(iv++, radius * ArrayMath.cos(p - e) * ArrayMath.cos(t + e));
                this._vb.put(iv++, radius * ArrayMath.cos(p - e) * ArrayMath.sin(t + e));
                this._vb.put(iv++, radius * ArrayMath.sin(p - e));
                this._nb.put(in++, u);
                this._nb.put(in++, v);
                this._nb.put(in++, w);
                this._nb.put(in++, u);
                this._nb.put(in++, v);
                this._nb.put(in++, w);
                this._nb.put(in++, u);
                this._nb.put(in++, v);
                this._nb.put(in++, w);
                this._nb.put(in++, u);
                this._nb.put(in++, v);
                this._nb.put(in++, w);
                this._cb.put(ic++, r);
                this._cb.put(ic++, g);
                this._cb.put(ic++, b);
                this._cb.put(ic++, r);
                this._cb.put(ic++, g);
                this._cb.put(ic++, b);
                this._cb.put(ic++, r);
                this._cb.put(ic++, g);
                this._cb.put(ic++, b);
                this._cb.put(ic++, r);
                this._cb.put(ic++, g);
                this._cb.put(ic++, b);
            }
        }
    };

    public static void main(String[] args) {
        TestSimple.run(args, canvas, true);
    }
}

