/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.DMatrixLud;
import edu.mines.jtk.lapack.DMatrixTest;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DMatrixLudTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(DMatrixLudTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSimple() {
        DMatrix a = new DMatrix(new double[][]{{0.0, 2.0}, {3.0, 4.0}});
        this.test(a);
        DMatrixLud lud = new DMatrixLud(a);
        DMatrixTest.assertEqualFuzzy(-6.0, lud.det());
    }

    public void testRandom() {
        this.test(DMatrix.random(100, 100));
        this.test(DMatrix.random(101, 100));
        this.test(DMatrix.random(100, 101));
    }

    private void test(DMatrix a) {
        int m = a.getM();
        int n = a.getN();
        DMatrixLud lud = new DMatrixLud(a);
        DMatrixLudTest.assertFalse((boolean)lud.isSingular());
        int[] pi = lud.getPivotIndices();
        DMatrix p = lud.getP();
        DMatrix l = lud.getL();
        DMatrix u = lud.getU();
        DMatrix lu = l.times(u);
        DMatrix plu = p.times(lu);
        DMatrix ap = a.get(pi, null);
        DMatrixTest.assertEqualFuzzy(ap, lu);
        DMatrixTest.assertEqualFuzzy(a, plu);
        if (m == n) {
            int nrhs = 10;
            DMatrix b = DMatrix.random(m, nrhs);
            DMatrix x = lud.solve(b);
            DMatrix ax = a.times(x);
            DMatrixTest.assertEqualFuzzy(ax, b);
        }
    }
}

