/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign;

import net.imagej.Dataset;
import net.imagej.Position;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.overlay.Overlay;
import net.imagej.plugins.commands.assign.NoiseAdder;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Noise", mnemonic=110), @Menu(label="Add Specified Noise...", weight=2.0)}, headless=true, attrs={@Attr(name="no-legacy")})
public class AddSpecifiedNoiseToDataValues<T extends RealType<T>>
extends ContextCommand {
    @Parameter
    private ImageDisplayService displayService;
    @Parameter
    private OverlayService overlayService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    @Parameter(label="Standard deviation")
    private double stdDev;
    @Parameter(label="Apply to all planes")
    private boolean allPlanes;

    public void run() {
        Dataset dataset = this.displayService.getActiveDataset(this.display);
        Overlay overlay = this.overlayService.getActiveOverlay(this.display);
        DatasetView view = this.displayService.getActiveDatasetView(this.display);
        Position planePos = this.allPlanes ? null : view.getPlanePosition();
        NoiseAdder noiseAdder = new NoiseAdder(dataset, overlay, planePos);
        noiseAdder.setStdDev(this.stdDev);
        noiseAdder.run();
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    public boolean isAllPlanes() {
        return this.allPlanes;
    }

    public void setAllPlanes(boolean value) {
        this.allPlanes = value;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public void setStdDev(double stdDev) {
        this.stdDev = stdDev;
    }
}

