/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.comm;

import com.twosigma.beaker.jupyter.comm.BaseHandler;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.handler.KernelHandlerWrapper;
import com.twosigma.jupyter.message.Message;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelControlCommandListHandler
extends BaseHandler<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(KernelControlCommandListHandler.class);
    public static final String GET_KERNEL_CONTROL_COMMAND_LIST = "get_kernel_control_command_list";
    public static final String KERNEL_CONTROL_RESPONSE = "kernel_control_response";

    public KernelControlCommandListHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle(this.kernel, message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        logger.debug("Handing comm message content");
        Boolean value = (Boolean)this.getValueFromData(message, this.getHandlerCommand());
        if (value != null && value.booleanValue()) {
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            data.put(KERNEL_CONTROL_RESPONSE, this.getCommKernelControlCommandList());
            this.publish(this.createReplyMessage(message, data));
        }
    }

    protected String[] getCommKernelControlCommandList() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(GET_KERNEL_CONTROL_COMMAND_LIST);
        ret.add("get_default_shell");
        ret.add("kernel_interrupt");
        ret.add("classpath");
        ret.add("imports");
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String getHandlerCommand() {
        return GET_KERNEL_CONTROL_COMMAND_LIST;
    }
}

