/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beaker.chart.serializer.AbstractChartSerializer;
import com.twosigma.beaker.chart.xychart.XYChart;
import java.io.IOException;

public class XYChartSerializer
extends AbstractChartSerializer<XYChart> {
    public static final String GRAPHICS_LIST = "graphics_list";
    public static final String LOD_THRESHOLD = "lodThreshold";

    public void serialize(XYChart xychart, JsonGenerator jgen, SerializerProvider sp) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        this.serialize(xychart, jgen);
        jgen.writeObjectField(GRAPHICS_LIST, xychart.getGraphics());
        jgen.writeObjectField("constant_lines", xychart.getConstantLines());
        jgen.writeObjectField("constant_bands", xychart.getConstantBands());
        jgen.writeObjectField("rasters", xychart.getRasters());
        jgen.writeObjectField("texts", xychart.getTexts());
        jgen.writeObjectField("x_auto_range", (Object)xychart.getXAutoRange());
        jgen.writeObjectField("x_lower_bound", (Object)xychart.getXLowerBound());
        jgen.writeObjectField("x_upper_bound", (Object)xychart.getXUpperBound());
        jgen.writeObjectField("log_x", (Object)xychart.getLogX());
        jgen.writeObjectField("x_log_base", (Object)xychart.getXLogBase());
        if (xychart.getLodThreshold() != null) {
            jgen.writeObjectField(LOD_THRESHOLD, (Object)xychart.getLodThreshold());
        }
        jgen.writeObjectField("x_tickLabels_visible", (Object)xychart.isxTickLabelsVisible());
        jgen.writeObjectField("y_tickLabels_visible", (Object)xychart.isyTickLabelsVisible());
        jgen.writeEndObject();
    }
}

