/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.chart;

import com.twosigma.beaker.chart.Color;
import com.twosigma.beaker.chart.KeyboardCodes;
import com.twosigma.beaker.chart.actions.GraphicsActionListener;
import com.twosigma.beaker.chart.actions.GraphicsActionObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class Graphics
implements Serializable,
Cloneable {
    private final String uid;
    private boolean visible = true;
    private String yAxisName = null;
    private GraphicsActionListener onClickListener;
    private String clickTag;
    private Map<String, GraphicsActionListener> onKeyListeners = new HashMap<String, GraphicsActionListener>();
    private Map<String, String> keyTags = new HashMap<String, String>();

    public Graphics() {
        this.uid = UUID.randomUUID().toString();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setYAxis(String yAxisName) {
        this.yAxisName = yAxisName;
    }

    public void setyAxis(String yAxisName) {
        this.yAxisName = yAxisName;
    }

    public String getYAxis() {
        return this.yAxisName;
    }

    public String getUid() {
        return this.uid;
    }

    public boolean hasClickAction() {
        return this.onClickListener != null || StringUtils.isNotEmpty((CharSequence)this.clickTag);
    }

    public String getClickTag() {
        return this.clickTag;
    }

    public Map<String, String> getKeyTags() {
        return this.keyTags;
    }

    public Object[] getKeys() {
        return this.onKeyListeners.keySet().toArray();
    }

    public Graphics onClick(GraphicsActionListener onClickListener) {
        this.onClickListener = onClickListener;
        return this;
    }

    public Graphics onClick(String tag) {
        this.clickTag = tag;
        return this;
    }

    public void fireClick(GraphicsActionObject actionObject) {
        if (this.onClickListener != null) {
            actionObject.setGraphics(this);
            this.onClickListener.execute(actionObject);
        }
    }

    public Graphics onKey(String key, GraphicsActionListener listener) {
        this.onKeyListeners.put(key, listener);
        return this;
    }

    public Graphics onKey(KeyboardCodes key, GraphicsActionListener listener) {
        this.onKeyListeners.put(key.name(), listener);
        return this;
    }

    public Graphics onKey(String key, String tag) {
        this.keyTags.put(key, tag);
        return this;
    }

    public Graphics onKey(KeyboardCodes key, String tag) {
        this.keyTags.put(key.name(), tag);
        return this;
    }

    public void fireOnKey(String key, GraphicsActionObject actionObject) {
        GraphicsActionListener listener = this.onKeyListeners.get(key);
        if (listener != null) {
            actionObject.setGraphics(this);
            listener.execute(actionObject);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return SerializationUtils.clone((Serializable)this);
    }

    public abstract void setColori(Color var1);

    public abstract Color getColor();
}

