/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.threshold;

import net.imagej.threshold.AbstractThresholdMethod;
import net.imagej.threshold.MeanThresholdMethod;
import net.imagej.threshold.ThresholdMethod;
import net.imagej.threshold.Utils;
import net.imglib2.histogram.Histogram1d;
import org.scijava.plugin.Plugin;

@Deprecated
@Plugin(type=ThresholdMethod.class, name="MinError(I)")
public class MinErrorThresholdMethod
extends AbstractThresholdMethod {
    private String errMsg = null;

    @Override
    public long getThreshold(Histogram1d<?> hist) {
        long[] histogram = hist.toLongArray();
        int threshold = (int)new MeanThresholdMethod().getThreshold(hist);
        int Tprev = -2;
        while (threshold != Tprev) {
            double w2;
            double w0;
            double tau2;
            double mu = Utils.B(histogram, threshold) / Utils.A(histogram, threshold);
            double nu = (Utils.B(histogram, histogram.length - 1) - Utils.B(histogram, threshold)) / (Utils.A(histogram, histogram.length - 1) - Utils.A(histogram, threshold));
            double p = Utils.A(histogram, threshold) / Utils.A(histogram, histogram.length - 1);
            double q = (Utils.A(histogram, histogram.length - 1) - Utils.A(histogram, threshold)) / Utils.A(histogram, histogram.length - 1);
            double sigma2 = Utils.C(histogram, threshold) / Utils.A(histogram, threshold) - mu * mu;
            double w1 = mu / sigma2 - nu / (tau2 = (Utils.C(histogram, histogram.length - 1) - Utils.C(histogram, threshold)) / (Utils.A(histogram, histogram.length - 1) - Utils.A(histogram, threshold)) - nu * nu);
            double sqterm = w1 * w1 - (w0 = 1.0 / sigma2 - 1.0 / tau2) * (w2 = mu * mu / sigma2 - nu * nu / tau2 + Math.log10(sigma2 * (q * q) / (tau2 * (p * p))));
            if (sqterm < 0.0) {
                this.errMsg = "MinError(I): not converging. Try 'Ignore black/white' options";
                return threshold;
            }
            Tprev = threshold;
            double temp = (w1 + Math.sqrt(sqterm)) / w0;
            if (Double.isNaN(temp)) {
                this.errMsg = "MinError(I): NaN, not converging. Try 'Ignore black/white' options";
                threshold = Tprev;
                continue;
            }
            threshold = (int)Math.floor(temp);
        }
        return threshold;
    }

    @Override
    public String getMessage() {
        return this.errMsg;
    }
}

