/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.scijava.prefs.PrefService;
import org.scijava.ui.swing.script.TextEditor;

public class RecentFilesMenuItem
extends JMenu {
    protected final int maxCount = 10;
    protected final int maxLength = 35;
    protected final LinkedList<String> recentFiles = new LinkedList();
    protected static final String RECENT_FILES_PREFS_PREFIX = "script.editor.recent";
    private final PrefService prefService;
    private final TextEditor editor;

    public RecentFilesMenuItem(PrefService prefService, TextEditor editor) {
        super("Open Recent");
        String item;
        this.editor = editor;
        this.prefService = prefService;
        Stack<String> prefs = new Stack<String>();
        for (int i = 1; i <= 10 && (item = prefService.get(this.getClass(), RECENT_FILES_PREFS_PREFIX + i, null)) != null; ++i) {
            prefs.push(item);
        }
        if (prefs.empty()) {
            this.setEnabled(false);
        } else {
            while (!prefs.empty()) {
                this.add((String)prefs.pop());
            }
        }
    }

    @Override
    public JMenuItem add(final String path) {
        this.setEnabled(true);
        int i = 0;
        Iterator iter = this.recentFiles.iterator();
        while (iter.hasNext()) {
            String item = (String)iter.next();
            if (item.equals(path)) {
                if (i == 0) {
                    return this.getItem(i);
                }
                iter.remove();
                this.remove(i);
                continue;
            }
            ++i;
        }
        if (this.recentFiles.size() + 1 >= 10) {
            this.recentFiles.removeLast();
            this.remove(8);
        }
        this.recentFiles.add(0, path);
        i = 1;
        for (String item : this.recentFiles) {
            this.prefService.put(this.getClass(), RECENT_FILES_PREFS_PREFIX + i, item);
            ++i;
        }
        String label = path;
        if (path.length() > 35) {
            label = "..." + path.substring(path.length() - 35 + 3);
        }
        this.insert(label, 0);
        JMenuItem result = this.getItem(0);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentFilesMenuItem.this.editor.open(new File(path));
            }
        });
        return result;
    }
}

