/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.scijava.ui.swing.script.ErrorHandler;
import org.scijava.ui.swing.script.TextEditor;
import org.scijava.ui.swing.script.TextEditorTab;
import org.scijava.util.AppUtils;
import org.scijava.util.FileUtils;
import org.scijava.util.LineOutputStream;
import org.scijava.util.ProcessUtils;

public class FileFunctions {
    protected TextEditor parent;
    protected static Map<String, List<String>> class2source;

    public FileFunctions(TextEditor parent) {
        this.parent = parent;
    }

    public List<String> extractSourceJar(String path, File workspace) throws IOException {
        String baseName = new File(path).getName();
        if (baseName.endsWith(".jar") || baseName.endsWith(".zip")) {
            baseName = baseName.substring(0, baseName.length() - 4);
        }
        File baseDirectory = new File(workspace, baseName);
        ArrayList<String> result = new ArrayList<String>();
        JarFile jar = new JarFile(path);
        for (JarEntry entry : Collections.list(jar.entries())) {
            String name = entry.getName();
            if (name.endsWith(".class") || name.endsWith("/")) continue;
            String destination = baseDirectory + name;
            this.copyTo(jar.getInputStream(entry), destination);
            result.add(destination);
        }
        return result;
    }

    protected void copyTo(InputStream in, String destination) throws IOException {
        File file = new File(destination);
        this.makeParentDirectories(file);
        this.copyTo(in, new FileOutputStream(file));
    }

    protected void copyTo(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] buffer = new byte[16384];
        while ((count = in.read(buffer)) >= 0) {
            out.write(buffer, 0, count);
        }
        in.close();
        out.close();
    }

    protected void makeParentDirectories(File file) {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            this.makeParentDirectories(parent);
            parent.mkdir();
        }
    }

    public boolean isBinaryFile(String path) {
        try {
            int offset;
            int count;
            FileInputStream in = new FileInputStream(path);
            byte[] buffer = new byte[1024];
            for (offset = 0; offset < buffer.length && (count = ((InputStream)in).read(buffer, offset, buffer.length - offset)) >= 0; offset += count) {
            }
            ((InputStream)in).close();
            while (offset > 0) {
                if (buffer[--offset] != 0) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public String getSourcePath(String className) throws ClassNotFoundException {
        throw new RuntimeException("TODO");
    }

    public String getSourceURL(String className) {
        return "http://fiji.sc/" + className.replace('.', '/') + ".java";
    }

    public String findSourcePath(String className, File workspace) {
        int dot;
        String baseName;
        List<String> paths;
        if (class2source == null) {
            if (JOptionPane.showConfirmDialog(this.parent, "The class " + className + " was not found in the CLASSPATH. Do you want me to search for the source?", "Question", 0) != 0) {
                return null;
            }
            class2source = new HashMap<String, List<String>>();
            this.findJavaPaths(workspace, "");
        }
        if ((paths = class2source.get(baseName = className.substring((dot = className.lastIndexOf(46)) + 1))) == null || paths.size() == 0) {
            JOptionPane.showMessageDialog(this.parent, "No source for class '" + className + "' was not found!");
            return null;
        }
        if (dot >= 0) {
            String suffix = "/" + className.replace('.', '/') + ".java";
            paths = new ArrayList<String>(paths);
            Iterator<String> iter = paths.iterator();
            while (iter.hasNext()) {
                if (iter.next().endsWith(suffix)) continue;
                iter.remove();
            }
            if (paths.size() == 0) {
                JOptionPane.showMessageDialog(this.parent, "No source for class '" + className + "' was not found!");
                return null;
            }
        }
        if (paths.size() == 1) {
            return new File(workspace, paths.get(0)).getAbsolutePath();
        }
        String[] names = paths.toArray(new String[paths.size()]);
        JFileChooser chooser = new JFileChooser(workspace);
        chooser.setDialogTitle("Choose path");
        if (chooser.showOpenDialog(this.parent) != 0) {
            return null;
        }
        return chooser.getSelectedFile().getPath();
    }

    protected void findJavaPaths(File directory, String prefix) {
        Object[] files = directory.list();
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            File file;
            if (((String)files[i]).endsWith(".java")) {
                String baseName = ((String)files[i]).substring(0, ((String)files[i]).length() - 5);
                List<String> list = class2source.get(baseName);
                if (list == null) {
                    list = new ArrayList<String>();
                    class2source.put(baseName, list);
                }
                list.add(prefix + "/" + (String)files[i]);
                continue;
            }
            if ("".equals(prefix) && (((String)files[i]).equals("full-nightly-build") || ((String)files[i]).equals("livecd") || ((String)files[i]).equals("java") || ((String)files[i]).equals("nightly-build") || ((String)files[i]).equals("other") || ((String)files[i]).equals("work") || ((String)files[i]).startsWith("chroot-")) || !(file = new File(directory, (String)files[i])).isDirectory()) continue;
            this.findJavaPaths(file, prefix + "/" + (String)files[i]);
        }
    }

    protected String readStream(InputStream in) throws IOException {
        int count;
        StringBuffer buf = new StringBuffer();
        byte[] buffer = new byte[65536];
        while ((count = in.read(buffer)) >= 0) {
            buf.append(new String(buffer, 0, count));
        }
        in.close();
        return buf.toString();
    }

    public void listFilesRecursively(File directory, String prefix, List<String> result) {
        if (!directory.exists()) {
            return;
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.listFilesRecursively(file, prefix + file.getName() + "/", result);
                continue;
            }
            if (!file.isFile()) continue;
            result.add(prefix + file.getName());
        }
    }

    public List<String> getResourceList(String url) {
        ArrayList<String> result = new ArrayList<String>();
        if (url.startsWith("jar:")) {
            int bang = url.indexOf("!/");
            String jarURL = url.substring(4, bang);
            if (jarURL.startsWith("file:")) {
                jarURL = jarURL.substring(5);
            }
            String prefix = url.substring(bang + 2);
            int prefixLength = prefix.length();
            try {
                JarFile jar = new JarFile(jarURL);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (!entry.getName().startsWith(prefix)) continue;
                    result.add(entry.getName().substring(prefixLength));
                }
            }
            catch (IOException e) {
                this.parent.handleException(e);
            }
        } else {
            String prefix = "file:";
            if (url.startsWith("file:")) {
                int skip = "file:".length();
                if (url.startsWith("file://")) {
                    ++skip;
                }
                url = url.substring(skip);
            }
            this.listFilesRecursively(new File(url), "", result);
        }
        return result;
    }

    public File getGitDirectory(File file) {
        File git;
        if (file == null) {
            return null;
        }
        do {
            if ((file = file.getParentFile()) != null) continue;
            return null;
        } while (!(git = new File(file, ".git")).isDirectory());
        return git;
    }

    public File getPluginRootDirectory(File file) {
        if (file == null) {
            return null;
        }
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if (file == null) {
            return null;
        }
        File git = new File(file, ".git");
        if (git.isDirectory()) {
            return file;
        }
        File backup = file;
        File parent;
        while ((parent = file.getParentFile()) != null) {
            git = new File(parent, ".git");
            if (git.isDirectory()) {
                return file.getName().equals("src-plugins") ? backup : file;
            }
            backup = file;
            file = parent;
        }
        return null;
    }

    public String firstNLines(String text, int maxLineCount) {
        int offset = -1;
        while (maxLineCount-- > 0) {
            if ((offset = text.indexOf(10, offset + 1)) >= 0) continue;
            return text;
        }
        int count = 0;
        int next = offset;
        while ((next = text.indexOf(10, next + 1)) > 0) {
            ++count;
        }
        return count == 0 ? text : text.substring(0, offset + 1) + "(" + count + " more line" + (count > 1 ? "s" : "") + ")...\n";
    }

    public void gitGrep(String searchTerm, File directory) {
        GrepLineHandler handler = new GrepLineHandler(this.parent.getErrorScreen(), directory.getAbsolutePath());
        PrintStream out = new PrintStream(handler);
        this.parent.getTab().showErrors();
        try {
            ProcessUtils.exec(directory, out, out, "git", "grep", "-n", searchTerm);
            this.parent.setErrorHandler(handler.errorHandler);
        }
        catch (RuntimeException e) {
            this.parent.handleException(e);
        }
    }

    public void openInGitweb(File file, File gitDirectory, int line) {
        if (file == null || gitDirectory == null) {
            this.error("No file or git directory");
            return;
        }
        String url = this.getGitwebURL(file, gitDirectory, line);
        if (url == null) {
            this.error("Could not get gitweb URL for " + file);
        } else {
            try {
                this.parent.getPlatformService().open(new URL(url));
            }
            catch (MalformedURLException e) {
                this.parent.handleException(e);
            }
            catch (IOException e) {
                this.parent.handleException(e);
            }
        }
    }

    public String git(File gitDirectory, File workingDirectory, String ... args) {
        try {
            String[] stringArray;
            if (gitDirectory == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "git";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "git";
                stringArray = stringArray3;
                stringArray3[1] = "--git-dir=" + gitDirectory.getAbsolutePath();
            }
            args = this.append(stringArray, args);
            PrintStream out = new PrintStream(new ScreenOutputStream());
            return ProcessUtils.exec(workingDirectory, out, out, args);
        }
        catch (RuntimeException e) {
            this.parent.write(e.getMessage());
            return null;
        }
    }

    public String git(File gitDirectory, String ... args) {
        return this.git(gitDirectory, (File)null, args);
    }

    public String gitConfig(File gitDirectory, String key) {
        return this.git(gitDirectory, "config", key);
    }

    public String getGitwebURL(File file, File gitDirectory, int line) {
        String url = this.gitConfig(gitDirectory, "remote.origin.url");
        if (url == null) {
            String remote = this.gitConfig(gitDirectory, "branch.master.remote");
            if (remote != null) {
                url = this.gitConfig(gitDirectory, "remote." + remote + ".url");
            }
            if (url == null) {
                return null;
            }
        }
        if (url.startsWith("repo.or.cz:") || url.startsWith("ssh://repo.or.cz/")) {
            int index = url.indexOf("/srv/git/") + "/srv/git/".length();
            url = "http://repo.or.cz/w/" + url.substring(index);
        } else if (url.startsWith("git://repo.or.cz/")) {
            url = "http://repo.or.cz/w/" + url.substring("git://repo.or.cz/".length());
        } else {
            String project;
            url = this.stripSuffix(url, "/");
            int slash = url.lastIndexOf(47);
            if (url.endsWith("/.git")) {
                slash = url.lastIndexOf(47, slash - 1);
            }
            if (!(project = url.substring(slash + 1)).endsWith(".git")) {
                project = project + "/.git";
            }
            if (project.equals("imageja.git")) {
                project = "ImageJA.git";
            }
            url = "http://fiji.sc/cgi-bin/gitweb.cgi?p=" + project;
        }
        String head = this.git(gitDirectory, "rev-parse", "--symbolic-full-name", "HEAD");
        String path = this.git(null, file.getParentFile(), "ls-files", "--full-name", file.getName());
        if (url == null || head == null || path == null) {
            return null;
        }
        return url + ";a=blob;f=" + path + ";hb=" + head + (line < 0 ? "" : "#l" + line);
    }

    protected String[] append(String[] array, String item) {
        String[] result = new String[array.length + 1];
        System.arraycopy(array, 0, result, 0, array.length);
        result[array.length] = item;
        return result;
    }

    protected String[] append(String[] array, String[] append) {
        String[] result = new String[array.length + append.length];
        System.arraycopy(array, 0, result, 0, array.length);
        System.arraycopy(append, 0, result, array.length, append.length);
        return result;
    }

    protected String stripSuffix(String string, String suffix) {
        if (string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    protected boolean error(String message) {
        JOptionPane.showMessageDialog(this.parent, message);
        return false;
    }

    @Deprecated
    public static Map<String, URL> findResources(String regex, String pathPrefix) {
        File baseDirectory = AppUtils.getBaseDirectory("imagej.dir", FileFunctions.class, null);
        return FileUtils.findResources(regex, pathPrefix, baseDirectory);
    }

    @Deprecated
    public static Map<String, URL> findResources(String regex, Iterable<URL> urls) {
        return FileUtils.findResources(regex, urls);
    }

    public static class GrepLineHandler
    extends LineOutputStream {
        protected static Pattern pattern = Pattern.compile("([A-Za-z]:[^:]*|[^:]+):([1-9][0-9]*):.*", 32);
        public ErrorHandler errorHandler;
        protected String directory;

        public GrepLineHandler(JTextArea textArea, String directory) {
            this.errorHandler = new ErrorHandler(textArea);
            if (!directory.endsWith("/")) {
                directory = directory + "/";
            }
            this.directory = directory;
        }

        @Override
        public void println(String line) {
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                this.errorHandler.addError(this.directory + matcher.group(1), Integer.parseInt(matcher.group(2)), line);
            } else {
                this.errorHandler.addError(null, -1, line);
            }
        }
    }

    public class ScreenOutputStream
    extends LineOutputStream {
        @Override
        public void println(String line) {
            TextEditorTab tab = FileFunctions.this.parent.getTab();
            tab.screen.insert(line + "\n", tab.screen.getDocument().getLength());
        }
    }

    public class TextWrapper
    implements DocumentListener {
        protected int width;

        public TextWrapper(int width) {
            this.width = width;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            final Document document = e.getDocument();
            int offset = e.getOffset() + e.getLength();
            if (offset <= this.width) {
                return;
            }
            try {
                String text = document.getText(0, offset);
                int newLine = text.lastIndexOf(10);
                if (offset - newLine <= this.width) {
                    return;
                }
                while (offset - newLine > this.width) {
                    int remove = 0;
                    int space = text.lastIndexOf(32, newLine + this.width);
                    if (space >= newLine) {
                        if (space > 0) {
                            int first;
                            for (first = space; first > newLine + 1 && text.charAt(first - 1) == ' '; --first) {
                            }
                            remove = space + 1 - first;
                            newLine = first;
                        } else {
                            newLine += this.width;
                        }
                        final int removeCount = remove;
                        final int at = newLine;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (removeCount > 0) {
                                        document.remove(at, removeCount);
                                    }
                                    document.insertString(at, "\n", null);
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        });
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }
    }

    public class LengthWarner
    implements DocumentListener {
        protected int width;
        protected JTextComponent component;
        protected Color normal;
        protected Color warn;

        public LengthWarner(int width, JTextComponent component) {
            this.width = width;
            this.component = component;
            this.normal = component.getForeground();
            this.warn = Color.red;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateColor();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateColor();
        }

        public void updateColor() {
            this.component.setForeground(this.component.getDocument().getLength() <= this.width ? this.normal : this.warn);
        }
    }
}

