/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.imagej.ops.Ops;
import net.imagej.ops.geom.GeometricOp;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geometric.Polygon;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.ConvexHull.class)
public class DefaultConvexHull2D
extends AbstractUnaryFunctionOp<Polygon, Polygon>
implements GeometricOp<Polygon, Polygon>,
Ops.Geometric.ConvexHull {
    @Override
    public Polygon calculate(Polygon input) {
        ArrayList<? extends RealLocalizable> RealPoints = new ArrayList<RealLocalizable>(input.getVertices());
        Collections.sort(RealPoints, new Comparator<RealLocalizable>(){

            @Override
            public int compare(RealLocalizable o1, RealLocalizable o2) {
                Double o2x;
                Double o1x = new Double(o1.getDoublePosition(0));
                int result = o1x.compareTo(o2x = new Double(o2.getDoublePosition(0)));
                if (result == 0) {
                    return new Double(o1.getDoublePosition(1)).compareTo(new Double(o2.getDoublePosition(1)));
                }
                return result;
            }
        });
        ArrayList<RealLocalizable> U = new ArrayList<RealLocalizable>();
        ArrayList<RealLocalizable> L = new ArrayList<RealLocalizable>();
        for (RealLocalizable realLocalizable : RealPoints) {
            while (L.size() >= 2 && this.ccw((RealLocalizable)L.get(L.size() - 2), (RealLocalizable)L.get(L.size() - 1), realLocalizable) <= 0.0) {
                L.remove(L.size() - 1);
            }
            L.add(realLocalizable);
        }
        Collections.reverse(RealPoints);
        for (RealLocalizable realLocalizable : RealPoints) {
            while (U.size() >= 2 && this.ccw((RealLocalizable)U.get(U.size() - 2), (RealLocalizable)U.get(U.size() - 1), realLocalizable) <= 0.0) {
                U.remove(U.size() - 1);
            }
            U.add(realLocalizable);
        }
        L.remove(L.size() - 1);
        U.remove(U.size() - 1);
        L.addAll(U);
        return new Polygon(L);
    }

    private double ccw(RealLocalizable o, RealLocalizable a, RealLocalizable b) {
        return (a.getDoublePosition(0) - o.getDoublePosition(0)) * (b.getDoublePosition(1) - o.getDoublePosition(1)) - (a.getDoublePosition(1) - o.getDoublePosition(1)) * (b.getDoublePosition(0) - o.getDoublePosition(0));
    }
}

