/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick.helper;

import net.imagej.ops.features.haralick.helper.CoocPX;
import net.imagej.ops.features.haralick.helper.CoocPY;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import org.scijava.plugin.Plugin;

@Plugin(type=CoocHXY.class)
public class CoocHXY
extends AbstractUnaryFunctionOp<double[][], double[]> {
    private static final double EPSILON = Double.MIN_NORMAL;
    private UnaryFunctionOp<double[][], double[]> coocPXFunc;
    private UnaryFunctionOp<double[][], double[]> coocPYFunc;

    @Override
    public void initialize() {
        super.initialize();
        this.coocPXFunc = Functions.unary(this.ops(), CoocPX.class, double[].class, double[][].class, new Object[0]);
        this.coocPYFunc = Functions.unary(this.ops(), CoocPY.class, double[].class, double[][].class, new Object[0]);
    }

    @Override
    public double[] calculate(double[][] matrix) {
        int i;
        double hx = 0.0;
        double hy = 0.0;
        double hxy1 = 0.0;
        double hxy2 = 0.0;
        int nrGrayLevels = matrix.length;
        double[] px = this.coocPXFunc.calculate(matrix);
        double[] py = this.coocPYFunc.calculate(matrix);
        for (i = 0; i < px.length; ++i) {
            hx += px[i] * Math.log(px[i] + Double.MIN_NORMAL);
        }
        hx = -hx;
        for (int j = 0; j < py.length; ++j) {
            hy += py[j] * Math.log(py[j] + Double.MIN_NORMAL);
        }
        hy = -hy;
        for (i = 0; i < nrGrayLevels; ++i) {
            for (int j = 0; j < nrGrayLevels; ++j) {
                hxy1 += matrix[i][j] * Math.log(px[i] * py[j] + Double.MIN_NORMAL);
                hxy2 += px[i] * py[j] * Math.log(px[i] * py[j] + Double.MIN_NORMAL);
            }
        }
        hxy1 = -hxy1;
        hxy2 = -hxy2;
        return new double[]{hx, hy, hxy1, hxy2};
    }
}

