/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.mini;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.io.InputFormat;
import org.jhotdraw.draw.io.OutputFormat;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.samples.svg.SVGDrawingPanel;

public class SVGDrawingPanelSample
extends JFrame {
    private JFileChooser openChooser;
    private JFileChooser saveChooser;
    private HashMap<FileFilter, InputFormat> fileFilterInputFormatMap;
    private HashMap<FileFilter, OutputFormat> fileFilterOutputFormatMap;
    private File file;
    private JMenu fileMenu;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenuItem saveAsMenuItem;
    private SVGDrawingPanel svgPanel;

    public SVGDrawingPanelSample() {
        this.initComponents();
        this.setSize(new Dimension(600, 400));
    }

    private void initComponents() {
        this.svgPanel = new SVGDrawingPanel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)this.svgPanel, "Center");
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open...");
        this.openMenuItem.addActionListener(formListener);
        this.fileMenu.add(this.openMenuItem);
        this.saveAsMenuItem.setText("Save As...");
        this.saveAsMenuItem.addActionListener(formListener);
        this.fileMenu.add(this.saveAsMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void open(ActionEvent evt) {
        JFileChooser fc = this.getOpenChooser();
        if (this.file != null) {
            fc.setSelectedFile(this.file);
        }
        if (fc.showOpenDialog(this) == 0) {
            this.svgPanel.setEnabled(false);
            final File selectedFile = fc.getSelectedFile();
            final InputFormat selectedFormat = this.fileFilterInputFormatMap.get(fc.getFileFilter());
            new Worker(){

                protected Object construct() throws IOException {
                    SVGDrawingPanelSample.this.svgPanel.read(selectedFile.toURI(), selectedFormat);
                    return null;
                }

                protected void done(Object value) {
                    SVGDrawingPanelSample.this.file = selectedFile;
                    SVGDrawingPanelSample.this.setTitle(SVGDrawingPanelSample.this.file.getName());
                }

                @Override
                protected void failed(Throwable error) {
                    error.printStackTrace();
                    JOptionPane.showMessageDialog(SVGDrawingPanelSample.this, "<html><b>Couldn't open file \"" + selectedFile.getName() + "\"<br>" + error.toString(), "Open File", 0);
                }

                @Override
                protected void finished() {
                    SVGDrawingPanelSample.this.svgPanel.setEnabled(true);
                }
            }.start();
        }
    }

    private void saveAs(ActionEvent evt) {
        JFileChooser fc = this.getSaveChooser();
        if (this.file != null) {
            fc.setSelectedFile(this.file);
        }
        if (fc.showSaveDialog(this) == 0) {
            this.svgPanel.setEnabled(false);
            final File selectedFile = fc.getFileFilter() instanceof ExtensionFileFilter ? ((ExtensionFileFilter)fc.getFileFilter()).makeAcceptable(fc.getSelectedFile()) : fc.getSelectedFile();
            final OutputFormat selectedFormat = this.fileFilterOutputFormatMap.get(fc.getFileFilter());
            new Worker(){

                protected Object construct() throws IOException {
                    SVGDrawingPanelSample.this.svgPanel.write(selectedFile.toURI(), selectedFormat);
                    return null;
                }

                protected void done(Object value) {
                    SVGDrawingPanelSample.this.file = selectedFile;
                    SVGDrawingPanelSample.this.setTitle(SVGDrawingPanelSample.this.file.getName());
                }

                @Override
                protected void failed(Throwable error) {
                    error.printStackTrace();
                    JOptionPane.showMessageDialog(SVGDrawingPanelSample.this, "<html><b>Couldn't save to file \"" + selectedFile.getName() + "\"<br>" + error.toString(), "Save As File", 0);
                }

                @Override
                protected void finished() {
                    SVGDrawingPanelSample.this.svgPanel.setEnabled(true);
                }
            }.start();
        }
    }

    private JFileChooser getOpenChooser() {
        if (this.openChooser == null) {
            this.openChooser = new JFileChooser();
            Drawing d = this.svgPanel.getDrawing();
            this.fileFilterInputFormatMap = new HashMap();
            FileFilter firstFF = null;
            for (InputFormat format : d.getInputFormats()) {
                FileFilter ff = format.getFileFilter();
                if (firstFF == null) {
                    firstFF = ff;
                }
                this.fileFilterInputFormatMap.put(ff, format);
                this.openChooser.addChoosableFileFilter(ff);
            }
            this.openChooser.setFileFilter(firstFF);
            this.openChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("fileFilterChanged")) {
                        InputFormat inputFormat = (InputFormat)SVGDrawingPanelSample.this.fileFilterInputFormatMap.get(evt.getNewValue());
                        SVGDrawingPanelSample.this.openChooser.setAccessory(inputFormat == null ? null : inputFormat.getInputFormatAccessory());
                    }
                }
            });
        }
        return this.openChooser;
    }

    private JFileChooser getSaveChooser() {
        if (this.saveChooser == null) {
            this.saveChooser = new JFileChooser();
            Drawing d = this.svgPanel.getDrawing();
            this.fileFilterOutputFormatMap = new HashMap();
            FileFilter firstFF = null;
            for (OutputFormat format : d.getOutputFormats()) {
                FileFilter ff = format.getFileFilter();
                if (firstFF == null) {
                    firstFF = ff;
                }
                this.fileFilterOutputFormatMap.put(ff, format);
                this.saveChooser.addChoosableFileFilter(ff);
            }
            this.saveChooser.setFileFilter(firstFF);
            this.saveChooser.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("fileFilterChanged")) {
                        OutputFormat outputFormat = (OutputFormat)SVGDrawingPanelSample.this.fileFilterOutputFormatMap.get(evt.getNewValue());
                        SVGDrawingPanelSample.this.saveChooser.setAccessory(outputFormat == null ? null : outputFormat.getOutputFormatAccessory());
                    }
                }
            });
        }
        return this.saveChooser;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SVGDrawingPanelSample().setVisible(true);
            }
        });
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == SVGDrawingPanelSample.this.openMenuItem) {
                SVGDrawingPanelSample.this.open(evt);
            } else if (evt.getSource() == SVGDrawingPanelSample.this.saveAsMenuItem) {
                SVGDrawingPanelSample.this.saveAs(evt);
            }
        }
    }
}

