/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.scijava.log.LogService;

public class ProcessUtil {
    public static Map<String, String> executePythonCode(File pythonBinaryPath, String sourceCode, LogService log) {
        Map<String, String> results = null;
        try {
            File tempFile = File.createTempFile("scijava-script", ".py");
            Files.write(tempFile.toPath(), sourceCode.getBytes(), new OpenOption[0]);
            String[] cmd = new String[]{pythonBinaryPath.toString(), tempFile.toString()};
            results = ProcessUtil.executeProcess(cmd, log);
        }
        catch (IOException ex) {
            log.error(ex);
        }
        return results;
    }

    public static Map<String, String> executeProcess(String[] cmd, LogService log) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            BufferedReader outputStream = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String output = outputStream.lines().collect(Collectors.joining("\n"));
            BufferedReader errorStream = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String error = errorStream.lines().collect(Collectors.joining("\n"));
            results.put("output", output);
            results.put("error", error);
        }
        catch (IOException | InterruptedException ex) {
            log.error(ex);
        }
        return results;
    }
}

