/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.kernel.evaluator;

import com.twosigma.beaker.autocomplete.AutocompleteResult;
import com.twosigma.beaker.evaluator.Evaluator;
import com.twosigma.beaker.jvm.object.SimpleEvaluationObject;
import com.twosigma.jupyter.KernelParameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.scijava.Context;
import org.scijava.jupyter.kernel.evaluator.Worker;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.thread.ThreadService;

public class ScijavaEvaluator
implements Evaluator {
    public static final String DEFAULT_LANGUAGE = "groovy";
    @Parameter
    private LogService log;
    @Parameter
    private transient ScriptService scriptService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    Context context;
    private final Map<String, ScriptEngine> scriptEngines;
    private final Map<String, ScriptLanguage> scriptLanguages;
    private String languageName;
    protected String shellId;
    protected String sessionId;

    public ScijavaEvaluator(Context context, String shellId, String sessionId) {
        context.inject(this);
        this.shellId = shellId;
        this.sessionId = sessionId;
        this.scriptEngines = new HashMap<String, ScriptEngine>();
        this.scriptLanguages = new HashMap<String, ScriptLanguage>();
        this.languageName = DEFAULT_LANGUAGE;
    }

    public void setShellOptions(KernelParameters kp) throws IOException {
        this.log.debug("Set shell options : " + kp);
    }

    public AutocompleteResult autocomplete(String code, int i) {
        ArrayList<String> matches = new ArrayList<String>();
        matches.add("Autocompletion does not work yet.");
        int startIndex = 0;
        AutocompleteResult ac = new AutocompleteResult(matches, startIndex);
        return ac;
    }

    public void killAllThreads() {
        this.log.debug("Kill All Threads");
        System.exit(0);
    }

    public void startWorker() {
    }

    public void evaluate(SimpleEvaluationObject seo, String code) {
        code = this.setLanguage(code);
        Worker worker = new Worker(this.context, this.scriptEngines, this.scriptLanguages);
        worker.setup(seo, code, this.languageName);
        this.threadService.queue(worker);
    }

    public void exit() {
        this.log.debug("Exiting DefaultEvaluator");
        System.exit(0);
    }

    private void addLanguage(String languageName) {
        if (this.scriptService.getLanguageByName(languageName) == null) {
            this.log.error("Script Language for '" + languageName + "' not found.");
            System.exit(1);
        }
        if (!this.scriptLanguages.keySet().contains(languageName)) {
            Bindings bindings = null;
            if (!this.scriptEngines.isEmpty()) {
                String firstLanguage = this.scriptEngines.keySet().iterator().next();
                bindings = this.scriptEngines.get(firstLanguage).getBindings(100);
            }
            this.log.info("Script Language for '" + languageName + "' found.");
            ScriptLanguage scriptLanguage = this.scriptService.getLanguageByName(languageName);
            this.scriptLanguages.put(languageName, scriptLanguage);
            ScriptEngine engine = this.scriptLanguages.get(languageName).getScriptEngine();
            this.scriptEngines.put(languageName, engine);
            if (bindings != null) {
                this.initBindings(bindings, engine, scriptLanguage);
            }
        }
        this.log.debug("Script Language found for '" + languageName + "'");
    }

    private String setLanguage(String code) {
        if (code.startsWith("#!")) {
            if (code.split("\n").length > 1) {
                this.languageName = code.substring(2, code.indexOf("\n")).trim();
                code = code.substring(code.indexOf("\n") + 1);
            } else {
                this.languageName = code.substring(2).trim();
                code = "";
            }
        }
        this.addLanguage(this.languageName);
        return code;
    }

    private void initBindings(Bindings bindings, ScriptEngine scriptEngine, ScriptLanguage scriptLanguage) {
        Bindings currentBindings = scriptEngine.getBindings(100);
        bindings.keySet().forEach(key -> currentBindings.put((String)key, scriptLanguage.decode(bindings.get(key))));
    }
}

