/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook;

import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.imagej.display.ColorTables;
import net.imagej.notebook.ImageJNotebookService;
import net.imagej.ops.OpEnvironment;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imagej.ops.special.inplace.Inplaces;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.RealLUTConverter;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import net.imglib2.display.projector.composite.CompositeXYProjector;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.img.Img;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultImageJNotebookService
extends AbstractService
implements ImageJNotebookService {
    @Parameter
    private LogService log;
    @Parameter
    private OpService ops;

    @Override
    public <T extends RealType<T>> Object RAIToPNG(RandomAccessibleInterval<T> source, int xAxis, int yAxis, int cAxis, ImageJNotebookService.ValueScaling scaling, long ... pos) {
        double max;
        double min;
        boolean full;
        IntervalView image = this.ops.transform().zeroMin(source);
        int w = xAxis >= 0 ? (int)image.dimension(xAxis) : 1;
        int h = yAxis >= 0 ? (int)image.dimension(yAxis) : 1;
        int c = cAxis >= 0 ? (int)image.dimension(cAxis) : 1;
        ARGBScreenImage target = new ARGBScreenImage(w, h);
        ArrayList<RealLUTConverter> converters = new ArrayList<RealLUTConverter>(c);
        boolean bl = full = scaling == ImageJNotebookService.ValueScaling.FULL || scaling == ImageJNotebookService.ValueScaling.AUTO && this.isNarrowType(source);
        if (full) {
            min = ((RealType)image.firstElement()).getMinValue();
            max = ((RealType)image.firstElement()).getMaxValue();
        } else {
            IterableInterval ii = this.ops.transform().flatIterable(source);
            Pair minMax = this.ops.stats().minMax((Iterable)ii);
            min = ((RealType)minMax.getA()).getRealDouble();
            max = ((RealType)minMax.getB()).getRealDouble();
        }
        for (int i = 0; i < c; ++i) {
            ColorTable8 lut = c == 1 ? ColorTables.GRAYS : ColorTables.getDefaultColorTable((int)i);
            converters.add(new RealLUTConverter(min, max, (ColorTable)lut));
        }
        CompositeXYProjector proj = new CompositeXYProjector((RandomAccessibleInterval)image, (IterableInterval)target, converters, cAxis);
        if (pos != null && pos.length > 0) {
            proj.setPosition(pos);
        }
        proj.setComposite(true);
        proj.map();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)target.image(), "PNG", os);
        }
        catch (IOException ex) {
            this.log.error(ex);
        }
        return Base64.getEncoder().encodeToString(os.toByteArray());
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> mosaic(int[] gridLayout, RandomAccessibleInterval<T> ... images) {
        int d;
        int numDims = 0;
        for (RandomAccessibleInterval<T> image : images) {
            numDims = Math.max(numDims, image.numDimensions());
        }
        int[] grid = new int[numDims];
        for (int d2 = 0; d2 < numDims; ++d2) {
            grid[d2] = d2 < gridLayout.length ? gridLayout[d2] : 1;
        }
        int[] pos = new int[numDims];
        long[][] extents = new long[numDims][];
        for (int d3 = 0; d3 < numDims; ++d3) {
            extents[d3] = new long[grid[d3]];
        }
        for (int i = 0; i < images.length; ++i) {
            IntervalIndexer.indexToPosition((int)i, (int[])grid, (int[])pos);
            for (d = 0; d < numDims; ++d) {
                if (pos[d] >= grid[d]) continue;
                extents[d][pos[d]] = Math.max(extents[d][pos[d]], images[i].dimension(d));
            }
        }
        long[][] offsets = new long[numDims][];
        for (d = 0; d < numDims; ++d) {
            offsets[d] = new long[grid[d] + 1];
        }
        for (d = 0; d < numDims; ++d) {
            for (int g = 0; g < grid[d]; ++g) {
                offsets[d][g + 1] = offsets[d][g] + extents[d][g];
            }
        }
        long[] mosaicDims = new long[numDims];
        for (int d4 = 0; d4 < numDims; ++d4) {
            mosaicDims[d4] = offsets[d4][offsets[d4].length - 1];
        }
        FinalInterval mosaicBox = new FinalInterval(mosaicDims);
        Img result = this.ops.create().img((Dimensions)mosaicBox, (NativeType)Util.getTypeFromInterval(images[0]));
        for (int i = 0; i < images.length; ++i) {
            IntervalIndexer.indexToPosition((int)i, (int[])grid, (int[])pos);
            boolean outOfBounds = false;
            for (int d5 = 0; d5 < numDims; ++d5) {
                if (pos[d5] < grid[d5]) continue;
                outOfBounds = true;
                break;
            }
            if (outOfBounds) continue;
            long[] offset = new long[numDims];
            for (int d6 = 0; d6 < numDims; ++d6) {
                offset[d6] = offsets[d6][pos[d6]];
            }
            MixedTransformView translated = this.ops.transform().translate((RandomAccessible)this.ops.transform().zeroMin(images[i]), offset);
            long[] max = new long[numDims];
            for (int d7 = 0; d7 < numDims; ++d7) {
                max[d7] = offset[d7] + images[i].dimension(d7) - 1L;
            }
            FinalInterval bounds = new FinalInterval(offset, max);
            IntervalView bounded = this.ops.transform().interval((RandomAccessible)translated, (Interval)bounds);
            ExtendedRandomAccessibleInterval extended = this.ops.transform().extendZero((RandomAccessibleInterval)bounded);
            IntervalView expanded = this.ops.transform().interval((RandomAccessible)extended, (Interval)mosaicBox);
            Inplaces.binary1((OpEnvironment)this.ops, Ops.Math.Add.class, (Object)result, (Object)expanded, (Object[])new Object[0]).mutate1((Object)result, (Object)expanded);
        }
        return result;
    }

    private <T extends RealType<T>> boolean isNarrowType(RandomAccessibleInterval<T> source) {
        return ((RealType)Util.getTypeFromInterval(source)).getBitsPerPixel() <= 8;
    }
}

