/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import mpicbg.models.CoordinateTransform;

public class CoordinateTransformMap2D
implements CoordinateTransform {
    private static final long serialVersionUID = 4762150526295594608L;
    protected final float[][] map;
    protected final int width;
    protected final int height;

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public CoordinateTransformMap2D(float[][] map) {
        this.map = map;
        this.width = map[0].length / 2;
        this.height = map.length;
    }

    public CoordinateTransformMap2D(CoordinateTransform t, int width, int height) {
        this.width = width;
        this.height = height;
        this.map = new float[height][width * 2];
        double[] l = new double[2];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                l[0] = x;
                l[1] = y;
                t.applyInPlace(l);
                this.map[y][2 * x] = (float)l[0];
                this.map[y][2 * x + 1] = (float)l[1];
            }
        }
    }

    public CoordinateTransformMap2D(FileInputStream fis) throws IOException {
        byte[] header = new byte[8];
        fis.read(header);
        long longWidth = ((0xFFL & (long)header[0]) << 24) + ((0xFFL & (long)header[1]) << 16) + ((0xFFL & (long)header[2]) << 8) + (0xFFL & (long)header[3]);
        this.width = (int)longWidth;
        long longHeight = ((0xFFL & (long)header[4]) << 24) + ((0xFFL & (long)header[5]) << 16) + ((0xFFL & (long)header[6]) << 8) + (0xFFL & (long)header[7]);
        this.height = (int)longHeight;
        this.map = new float[this.height][2 * this.width];
        byte[] byteRow = new byte[this.width * 8];
        for (int y = 0; y < this.height; ++y) {
            fis.read(byteRow);
            float[] row = this.map[y];
            for (int i = 0; i < row.length; i += 2) {
                int j = 4 * i;
                int tx = (0xFF & byteRow[j]) << 24 | (0xFF & byteRow[j + 1]) << 16 | (0xFF & byteRow[j + 2]) << 8 | 0xFF & byteRow[j + 3];
                int ty = (0xFF & byteRow[j + 4]) << 24 | (0xFF & byteRow[j + 5]) << 16 | (0xFF & byteRow[j + 6]) << 8 | 0xFF & byteRow[j + 7];
                row[i] = Float.intBitsToFloat(tx);
                row[i + 1] = Float.intBitsToFloat(ty);
            }
        }
    }

    public final void export(FileOutputStream fos) throws IOException {
        byte[] header = new byte[]{(byte)(this.width >> 24), (byte)(this.width >> 16), (byte)(this.width >> 8), (byte)this.width, (byte)(this.height >> 24), (byte)(this.height >> 16), (byte)(this.height >> 8), (byte)this.height};
        fos.write(header);
        byte[] byteRow = new byte[this.width * 8];
        for (int y = 0; y < this.height; ++y) {
            float[] row = this.map[y];
            for (int i = 0; i < row.length; i += 2) {
                int j = 4 * i;
                int tx = Float.floatToIntBits(row[i]);
                int ty = Float.floatToIntBits(row[i + 1]);
                byteRow[j] = (byte)(tx >> 24);
                byteRow[j + 1] = (byte)(tx >> 16);
                byteRow[j + 2] = (byte)(tx >> 8);
                byteRow[j + 3] = (byte)tx;
                byteRow[j + 4] = (byte)(ty >> 24);
                byteRow[j + 5] = (byte)(ty >> 16);
                byteRow[j + 6] = (byte)(ty >> 8);
                byteRow[j + 7] = (byte)ty;
            }
            fos.write(byteRow);
        }
        fos.close();
    }

    public final double[] apply(double[] location) {
        double[] t = (double[])location.clone();
        this.applyInPlace(t);
        return t;
    }

    public final void applyInPlace(double[] location) {
        int ix = 2 * (int)location[0];
        int iy = (int)location[1];
        float x = this.map[iy][ix];
        float y = this.map[iy][ix + 1];
        location[0] = x;
        location[1] = y;
    }
}

