/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.visualization;

import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import mpicbg.imagefeatures.Feature;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointVis {
    public static final void drawLocalPoints(ImageProcessor ip, Collection<? extends Point> points, Color color, int width, Rectangle srcRect, double magnification) {
        int oldLineWidth = ip.getLineWidth();
        ip.setColor(color);
        ip.setLineWidth(width);
        for (Point point : points) {
            double[] l = point.getL();
            double x = (l[0] + (double)srcRect.x) * magnification;
            double y = (l[1] + (double)srcRect.y) * magnification;
            ip.drawDot(Util.round(x), Util.round(y));
        }
        ip.setLineWidth(oldLineWidth);
    }

    public static final void drawLocalPoints(ImageProcessor ip, Collection<? extends Point> points, Color color, int width) {
        PointVis.drawLocalPoints(ip, points, color, width, new Rectangle(0, 0, ip.getWidth(), ip.getHeight()), 1.0);
    }

    public static final void drawWorldPoints(ImageProcessor ip, Collection<? extends Point> points, Color color, int width, Rectangle srcRect, double magnification) {
        int oldLineWidth = ip.getLineWidth();
        ip.setColor(color);
        ip.setLineWidth(width);
        for (Point point : points) {
            double[] w = point.getW();
            double x = (w[0] + (double)srcRect.x) * magnification;
            double y = (w[1] + (double)srcRect.y) * magnification;
            ip.drawDot(Util.round(x), Util.round(y));
        }
        ip.setLineWidth(oldLineWidth);
    }

    public static final void drawWorldPoints(ImageProcessor ip, Collection<? extends Point> points, Color color, int width) {
        PointVis.drawWorldPoints(ip, points, color, width, new Rectangle(0, 0, ip.getWidth(), ip.getHeight()), 1.0);
    }

    public static final void drawLocalPointMatchLines(ImageProcessor ip, Collection<? extends PointMatch> pointMatches, Color color, int width, Rectangle srcRect, Rectangle dstRect, double srcMagnification, double dstMagnification) {
        int oldLineWidth = ip.getLineWidth();
        ip.setColor(color);
        ip.setLineWidth(width);
        for (PointMatch pointMatch : pointMatches) {
            double[] l1 = pointMatch.getP1().getL();
            double x1 = (l1[0] + (double)srcRect.x) * srcMagnification;
            double y1 = (l1[1] + (double)srcRect.y) * srcMagnification;
            double[] l2 = pointMatch.getP2().getL();
            double x2 = (l2[0] + (double)dstRect.x) * dstMagnification;
            double y2 = (l2[1] + (double)dstRect.y) * dstMagnification;
            ip.drawLine(Util.round(x1), Util.round(y1), Util.round(x2), Util.round(y2));
        }
        ip.setLineWidth(oldLineWidth);
    }

    public static final void drawWorldPointMatchLines(ImageProcessor ip, Collection<? extends PointMatch> pointMatches, Color color, int width, Rectangle srcRect, Rectangle dstRect, double srcMagnification, double dstMagnification) {
        int oldLineWidth = ip.getLineWidth();
        ip.setColor(color);
        ip.setLineWidth(width);
        for (PointMatch pointMatch : pointMatches) {
            double[] w1 = pointMatch.getP1().getW();
            double x1 = (w1[0] + (double)srcRect.x) * srcMagnification;
            double y1 = (w1[1] + (double)srcRect.y) * srcMagnification;
            double[] w2 = pointMatch.getP2().getW();
            double x2 = (w2[0] + (double)dstRect.x) * dstMagnification;
            double y2 = (w2[1] + (double)dstRect.y) * dstMagnification;
            ip.drawLine(Util.round(x1), Util.round(y1), Util.round(x2), Util.round(y2));
        }
        ip.setLineWidth(oldLineWidth);
    }

    public static final void drawEpsilonCoordinates(ImageProcessor ip, Color color, int width) {
        int oldLineWidth = ip.getLineWidth();
        ip.setColor(color);
        ip.setLineWidth(width);
        int xCenter = ip.getWidth() / 2;
        int yCenter = ip.getHeight() / 2;
        int arrowLength = 6;
        int arrowRadius = 2;
        int maxX = Util.round(0.1 * (double)ip.getWidth() / 2.0 / 1.1);
        int maxY = Util.round(0.1 * (double)ip.getHeight() / 2.0 / 1.1);
        ip.drawLine(0, yCenter, ip.getWidth() - 1, yCenter);
        ip.drawLine(xCenter, 0, xCenter, ip.getHeight());
        for (int i = -2 * width; i <= 2 * width; ++i) {
            ip.drawLine(0, yCenter, 6 * width, yCenter + i);
            ip.drawLine(ip.getWidth() - 1, yCenter, ip.getWidth() - 1 - 6 * width, yCenter + i);
            ip.drawLine(xCenter, 0, xCenter + i, 6 * width);
            ip.drawLine(xCenter, ip.getHeight() - 1, xCenter + i, ip.getHeight() - 1 - 6 * width);
        }
        ip.drawLine(maxX, yCenter + 2, maxX, yCenter);
        ip.drawLine(ip.getWidth() - 1 - maxX, yCenter + 2, ip.getWidth() - 1 - maxX, yCenter);
        ip.drawLine(xCenter - 2, maxY, xCenter, maxY);
        ip.drawLine(xCenter - 2, ip.getHeight() - 1 - maxY, xCenter, ip.getHeight() - 1 - maxY);
        ip.setAntialiasedText(true);
        ip.setFont(new Font("Sans", 0, 14));
        ip.drawString("-\u03b5", maxX - 6, yCenter + 20);
        ip.drawString("\u03b5", ip.getWidth() - 1 - maxX - 3, yCenter + 20);
        ip.drawString("\u03b5", xCenter - 14, maxY + 6);
        ip.drawString("-\u03b5", xCenter - 19, ip.getHeight() - 1 - maxY + 6);
        ip.setLineWidth(oldLineWidth);
    }

    public static void drawFeaturePoints(ImageProcessor ip, Iterable<? extends Feature> features, Color color, int width, Rectangle srcRect, double magnification) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Feature feature : features) {
            points.add(new Point((double[])feature.location.clone()));
        }
        PointVis.drawLocalPoints(ip, points, color, width, srcRect, magnification);
    }

    public static final void drawFeaturePoints(ImageProcessor ip, Collection<? extends Feature> features, Color color, int width) {
        PointVis.drawFeaturePoints(ip, features, color, width, new Rectangle(0, 0, ip.getWidth(), ip.getHeight()), 1.0);
    }
}

