/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Shape;
import java.awt.geom.Point2D;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayView;
import net.imagej.overlay.LineOverlay;
import net.imagej.overlay.Overlay;
import net.imagej.ui.swing.overlay.AbstractJHotDrawAdapter;
import net.imagej.ui.swing.overlay.IJCreationTool;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import net.imagej.ui.swing.tools.SwingLineTool;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineFigure;
import org.jhotdraw.geom.BezierPath;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.tool.Tool;
import org.scijava.tool.ToolService;
import org.scijava.util.RealCoords;

@Plugin(type=JHotDrawAdapter.class, priority=97.0)
public class LineJHotDrawAdapter
extends AbstractJHotDrawAdapter<LineOverlay, LineFigure> {
    @Parameter
    private ToolService toolService;

    @Override
    public boolean supports(Tool tool) {
        return tool instanceof SwingLineTool;
    }

    @Override
    public boolean supports(Overlay overlay, Figure figure) {
        if (!(overlay instanceof LineOverlay)) {
            return false;
        }
        return figure == null || figure instanceof LineFigure;
    }

    public LineOverlay createNewOverlay() {
        return new LineOverlay(this.getContext());
    }

    @Override
    public Figure createDefaultFigure() {
        LineFigure figure = new LineFigure();
        this.initDefaultSettings(figure);
        return figure;
    }

    @Override
    public void updateFigure(OverlayView view, LineFigure figure) {
        super.updateFigure(view, figure);
        LineFigure lineFigure = figure;
        Overlay overlay = view.getData();
        assert (overlay instanceof LineOverlay);
        LineOverlay lineOverlay = (LineOverlay)overlay;
        double pt1X = lineOverlay.getLineStart(0);
        double pt1Y = lineOverlay.getLineStart(1);
        double pt2X = lineOverlay.getLineEnd(0);
        double pt2Y = lineOverlay.getLineEnd(1);
        lineFigure.setStartPoint(new Point2D.Double(pt1X, pt1Y));
        lineFigure.setEndPoint(new Point2D.Double(pt2X, pt2Y));
    }

    @Override
    public void updateOverlay(LineFigure figure, OverlayView view) {
        super.updateOverlay(figure, view);
        LineFigure line = figure;
        Overlay overlay = view.getData();
        assert (overlay instanceof LineOverlay);
        LineOverlay lineOverlay = (LineOverlay)overlay;
        BezierPath.Node startNode = line.getNode(0);
        double x1 = startNode.getControlPoint((int)0).x;
        double y1 = startNode.getControlPoint((int)0).y;
        lineOverlay.setLineStart(x1, 0);
        lineOverlay.setLineStart(y1, 1);
        BezierPath.Node endNode = line.getNode(1);
        double x2 = endNode.getControlPoint((int)0).x;
        double y2 = endNode.getControlPoint((int)0).y;
        lineOverlay.setLineEnd(x2, 0);
        lineOverlay.setLineEnd(y2, 1);
        lineOverlay.update();
        this.toolService.reportLine(x1, y1, x2, y2);
    }

    @Override
    public JHotDrawTool getCreationTool(ImageDisplay display) {
        return new IJCreationTool<LineFigure>(display, this);
    }

    @Override
    public void report(RealCoords p1, RealCoords p2) {
        this.toolService.reportLine(p1, p2);
    }

    @Override
    public Shape toShape(LineFigure figure) {
        return figure.getBezierPath().toGeneralPath();
    }
}

