/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import org.apache.commons.math.complex.Complex;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SEXPBuilder;
import org.renjin.sexp.Symbol;

public interface Vector
extends SEXP {
    public static final boolean DEBUG_ALLOC = false;

    public double getElementAsDouble(int var1);

    public int getElementAsInt(int var1);

    public String getElementAsString(int var1);

    public Logical getElementAsLogical(int var1);

    public int getElementAsRawLogical(int var1);

    public boolean isElementTrue(int var1);

    public byte getElementAsByte(int var1);

    public int indexOf(Vector var1, int var2, int var3);

    public boolean contains(Vector var1, int var2);

    public Complex getElementAsComplex(int var1);

    public Builder newBuilderWithInitialSize(int var1);

    public Builder newBuilderWithInitialCapacity(int var1);

    public Type getVectorType();

    public boolean isWiderThan(Vector var1);

    public Builder newCopyBuilder();

    public boolean isElementNA(int var1);

    public boolean isConstantAccessTime();

    public Object getElementAsObject(int var1);

    public int getComputationDepth();

    public static abstract class Type
    implements Comparable<Type> {
        private final int size;

        protected Type(int size) {
            this.size = size;
        }

        @Override
        public int compareTo(Type o) {
            return this.size - o.size;
        }

        public abstract Builder newBuilder();

        public abstract Builder newBuilderWithInitialSize(int var1);

        public abstract Builder newBuilderWithInitialCapacity(int var1);

        public final boolean isAtomic() {
            return this.size < 7;
        }

        public static Type forElement(SEXP element) {
            if (element instanceof AtomicVector) {
                return ((AtomicVector)element).getVectorType();
            }
            return ListVector.VECTOR_TYPE;
        }

        public final boolean isWiderThan(Type type) {
            return this.size > type.size;
        }

        public final boolean isWiderThan(Vector vector2) {
            return this.isWiderThan(vector2.getVectorType());
        }

        public final boolean isWiderThanOrEqualTo(Vector vector2) {
            return this.compareTo(vector2.getVectorType()) >= 0;
        }

        public final boolean isWiderThanOrEqualTo(Type vectorType) {
            return this.compareTo(vectorType) >= 0;
        }

        public abstract Vector getElementAsVector(Vector var1, int var2);

        public abstract int compareElements(Vector var1, int var2, Vector var3, int var4);

        public abstract boolean elementsEqual(Vector var1, int var2, Vector var3, int var4);

        public static Type widest(Type a, Type b) {
            if (b.isWiderThan(a)) {
                return b;
            }
            return a;
        }

        public static Type widest(Type a, Vector b) {
            return Type.widest(a, b.getVectorType());
        }

        public static Type widest(Vector vector2, SEXP element) {
            return Type.widest(vector2.getVectorType(), Type.forElement(element));
        }
    }

    public static class Order {
        public static final int NULL = 0;
        public static final int RAW = 1;
        public static final int LOGICAL = 2;
        public static final int INTEGER = 3;
        public static final int DOUBLE = 4;
        public static final int COMPLEX = 5;
        public static final int CHARACTER = 6;
        public static final int LIST = 7;
        public static final int EXPRESSION = 8;
    }

    public static interface Builder<S extends SEXP>
    extends SEXPBuilder {
        public Builder setNA(int var1);

        public Builder addNA();

        public Builder addFrom(S var1, int var2);

        public Builder setFrom(int var1, S var2, int var3);

        public Builder set(int var1, SEXP var2);

        public Builder add(SEXP var1);

        public Builder add(Number var1);

        @Override
        public Builder setAttribute(String var1, SEXP var2);

        @Override
        public Builder setAttribute(Symbol var1, SEXP var2);

        public Builder setDim(int var1, int var2);

        public SEXP getAttribute(Symbol var1);

        @Override
        public int length();

        @Override
        public Vector build();

        public Builder copyAttributesFrom(SEXP var1);

        public Builder copySomeAttributesFrom(SEXP var1, Symbol ... var2);
    }
}

