/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.ExpressionVisitor;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.eval.Context;
import org.renjin.sexp.SEXP;

public class Increment
implements Expression {
    private LValue counter;

    public Increment(LValue counter) {
        this.counter = counter;
    }

    public LValue getCounter() {
        return this.counter;
    }

    @Override
    public Set<Variable> variables() {
        return this.counter.variables();
    }

    public String toString() {
        return "increment counter " + this.counter;
    }

    @Override
    public Object retrieveValue(Context context, Object[] temps) {
        Integer counterValue = (Integer)this.counter.retrieveValue(context, temps);
        return counterValue + 1;
    }

    @Override
    public Expression replaceVariable(Variable variable, Variable newVariable) {
        return new Increment(this.counter.replaceVariable(variable, newVariable));
    }

    @Override
    public List<Expression> getChildren() {
        return Arrays.asList(this.counter);
    }

    @Override
    public void setChild(int i, Expression expr) {
        if (i != 0) {
            throw new IllegalArgumentException();
        }
        this.counter = (LValue)expr;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitIncrement(this);
    }

    @Override
    public SEXP getSExpression() {
        throw new UnsupportedOperationException();
    }
}

