/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.base.internals;

import com.google.common.collect.Sets;
import java.util.Set;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class AllNamesVisitor
extends SexpVisitor<StringVector> {
    private StringVector.Builder names = StringVector.newBuilder();
    private Set<Symbol> set = Sets.newIdentityHashSet();
    private boolean includeFunctionNames;
    private int maxNames;
    private boolean unique;

    @Override
    public void visit(ExpressionVector vector2) {
        for (SEXP expr : vector2) {
            expr.accept(this);
        }
    }

    @Override
    public void visit(FunctionCall call2) {
        if (this.includeFunctionNames) {
            call2.getFunction().accept(this);
        }
        for (SEXP expr : call2.getArguments().values()) {
            expr.accept(this);
        }
    }

    @Override
    public void visit(Symbol name) {
        if (!(this.unique && this.set.contains(name) || this.maxNames != -1 && this.names.length() >= this.maxNames)) {
            this.names.add(StringArrayVector.valueOf(name.getPrintName()));
            this.set.add(name);
        }
    }

    @Internal(value="all.names")
    public static StringVector allNames(SEXP expr, boolean function2, int maxNames, boolean unique2) {
        AllNamesVisitor visitor = new AllNamesVisitor();
        visitor.includeFunctionNames = function2;
        visitor.maxNames = maxNames;
        visitor.unique = unique2;
        expr.accept(visitor);
        return visitor.names.build();
    }
}

