/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parse.eval;

import java.util.HashMap;
import java.util.Map;
import org.scijava.parse.ExpressionParser;
import org.scijava.parse.SyntaxTree;
import org.scijava.parse.Tokens;
import org.scijava.parse.Variable;
import org.scijava.parse.eval.Evaluator;
import org.scijava.parse.eval.Unresolved;

public abstract class AbstractEvaluator
implements Evaluator {
    private final HashMap<String, Object> vars = new HashMap();
    private final ExpressionParser parser;
    private boolean strict = true;

    public AbstractEvaluator() {
        this(new ExpressionParser());
    }

    public AbstractEvaluator(ExpressionParser parser) {
        this.parser = parser;
    }

    @Override
    public ExpressionParser getParser() {
        return this.parser;
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public Object evaluate(SyntaxTree syntaxTree) {
        return this.evaluate(syntaxTree.postfix());
    }

    @Override
    public Object evaluate(String expression) {
        return this.evaluate(this.parser.parsePostfix(expression));
    }

    @Override
    public Object value(Object token) {
        return Tokens.isVariable(token) ? this.get((Variable)token) : token;
    }

    @Override
    public Object get(Variable v) {
        String name = v.getToken();
        if (this.vars.containsKey(name)) {
            return this.vars.get(name);
        }
        if (this.strict) {
            throw new IllegalArgumentException("Unknown variable: " + name);
        }
        return new Unresolved(name);
    }

    @Override
    public void set(Variable v, Object value) {
        this.vars.put(v.getToken(), value);
    }

    @Override
    public void setAll(Map<? extends String, ? extends Object> map) {
        this.vars.putAll(map);
    }
}

