/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.kdtree;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.imglib2.Interval;
import net.imglib2.KDTree;
import net.imglib2.KDTreeNode;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;

public class VolumetricSearch<I extends RealInterval>
implements RandomAccessible<List<I>> {
    final int numDimensions;
    final KDTree<IntervalWrapper<I>> kdtree;

    public VolumetricSearch(List<I> intervals) {
        this.numDimensions = intervals.isEmpty() ? 0 : ((RealInterval)intervals.get(0)).numDimensions();
        ArrayList<IntervalWrapper<RealInterval>> wrappers = new ArrayList<IntervalWrapper<RealInterval>>(intervals.size());
        for (RealInterval interval : intervals) {
            wrappers.add(new IntervalWrapper<RealInterval>(interval));
        }
        this.kdtree = new KDTree(wrappers, wrappers);
    }

    public List<I> find(RealLocalizable pt) {
        double[] position = new double[this.numDimensions];
        pt.localize(position);
        LinkedList list = new LinkedList();
        if (this.kdtree.getRoot() == null) {
            return list;
        }
        Stack<KDTreeNode> toDo = new Stack<KDTreeNode>();
        toDo.push(this.kdtree.getRoot());
        while (toDo.size() > 0) {
            KDTreeNode node = (KDTreeNode)toDo.pop();
            int k = node.getSplitDimension();
            Object interval = ((IntervalWrapper)node.get()).get();
            boolean good = true;
            for (int i = 0; i < this.numDimensions; ++i) {
                if (!(position[i] < interval.realMin(i)) && !(position[i] > interval.realMax(i))) continue;
                good = false;
                break;
            }
            if (good) {
                list.add(interval);
            }
            if (k < this.numDimensions) {
                if (node.left != null) {
                    toDo.push(node.left);
                }
                if (node.right == null || !(node.getSplitCoordinate() <= position[k])) continue;
                toDo.push(node.right);
                continue;
            }
            if (node.right != null) {
                toDo.push(node.right);
            }
            if (node.left == null || !(node.getSplitCoordinate() >= position[k - this.numDimensions])) continue;
            toDo.push(node.left);
        }
        return list;
    }

    public int numDimensions() {
        return this.numDimensions;
    }

    public RandomAccess<List<I>> randomAccess() {
        return new VolumetricSearchRandomAccess();
    }

    public RandomAccess<List<I>> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    private class VolumetricSearchRandomAccess
    extends Point
    implements RandomAccess<List<I>> {
        VolumetricSearchRandomAccess() {
            super(VolumetricSearch.this.numDimensions);
        }

        public List<I> get() {
            return VolumetricSearch.this.find((RealLocalizable)this);
        }

        public VolumetricSearchRandomAccess copy() {
            VolumetricSearchRandomAccess myCopy = new VolumetricSearchRandomAccess();
            myCopy.setPosition((Localizable)this);
            return myCopy;
        }

        public VolumetricSearchRandomAccess copyRandomAccess() {
            return this.copy();
        }
    }

    private static class IntervalWrapper<I extends RealInterval>
    implements RealLocalizable {
        final I interval;
        final int n;

        public IntervalWrapper(I interval) {
            this.interval = interval;
            this.n = interval.numDimensions();
        }

        public I get() {
            return this.interval;
        }

        public int numDimensions() {
            return 2 * this.n;
        }

        public void localize(float[] position) {
            for (int d = 0; d < this.n; ++d) {
                position[d] = (float)this.interval.realMin(d);
                position[d + this.n] = (float)this.interval.realMax(d);
            }
        }

        public void localize(double[] position) {
            for (int d = 0; d < this.n; ++d) {
                position[d] = this.interval.realMin(d);
                position[d + this.n] = this.interval.realMax(d);
            }
        }

        public float getFloatPosition(int d) {
            return (float)this.getDoublePosition(d);
        }

        public double getDoublePosition(int d) {
            return d < this.n ? this.interval.realMin(d) : this.interval.realMax(d - this.n);
        }
    }
}

