/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.kdtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.imglib2.KDTree;
import net.imglib2.KDTreeNode;
import net.imglib2.algorithm.kdtree.ConvexPolytope;
import net.imglib2.algorithm.kdtree.HyperPlane;
import net.imglib2.algorithm.kdtree.KDTreeNodeIterable;

public class ClipConvexPolytopeKDTree<T> {
    private final KDTree<T> tree;
    private final int n;
    private int nPlanes;
    private double[][] normals;
    private double[] ms;
    private final double[] xmin;
    private final double[] xmax;
    private boolean[] qR;
    private boolean[] qL;
    private final ArrayList<boolean[]> activeStack;
    private final ArrayList<boolean[]> psStack;
    private final ArrayList<KDTreeNode<T>> inNodes;
    private final ArrayList<KDTreeNode<T>> inSubtrees;
    private final ArrayList<KDTreeNode<T>> outNodes;
    private final ArrayList<KDTreeNode<T>> outSubtrees;

    public ClipConvexPolytopeKDTree(KDTree<T> tree) {
        this.tree = tree;
        this.n = tree.numDimensions();
        this.xmin = new double[this.n];
        this.xmax = new double[this.n];
        this.activeStack = new ArrayList();
        this.psStack = new ArrayList();
        this.inNodes = new ArrayList();
        this.inSubtrees = new ArrayList();
        this.outNodes = new ArrayList();
        this.outSubtrees = new ArrayList();
    }

    public int numDimensions() {
        return this.n;
    }

    public void clip(ConvexPolytope polytope) {
        Collection<? extends HyperPlane> planes = polytope.getHyperplanes();
        this.initNewSearch(planes.size());
        int i = 0;
        for (HyperPlane hyperPlane : planes) {
            double[] normal = this.normals[i];
            System.arraycopy(hyperPlane.getNormal(), 0, normal, 0, this.n);
            this.ms[i] = hyperPlane.getDistance();
            for (int d = 0; d < this.n; ++d) {
                this.qL[d * this.nPlanes + i] = normal[d] < 0.0;
                this.qR[d * this.nPlanes + i] = normal[d] >= 0.0;
            }
            ++i;
        }
        this.clip(this.tree.getRoot(), 0);
    }

    public void clip(double[][] planes) {
        this.initNewSearch(planes.length);
        for (int i = 0; i < this.nPlanes; ++i) {
            double[] normal = this.normals[i];
            System.arraycopy(planes[i], 0, normal, 0, this.n);
            this.ms[i] = planes[i][this.n];
            for (int d = 0; d < this.n; ++d) {
                this.qL[d * this.nPlanes + i] = normal[d] < 0.0;
                this.qR[d * this.nPlanes + i] = normal[d] >= 0.0;
            }
        }
        this.clip(this.tree.getRoot(), 0);
    }

    public Iterable<KDTreeNode<T>> getInsideNodes() {
        return new KDTreeNodeIterable<T>(this.inNodes, this.inSubtrees);
    }

    public Iterable<KDTreeNode<T>> getOutsideNodes() {
        return new KDTreeNodeIterable<T>(this.outNodes, this.outSubtrees);
    }

    private void initNewSearch(int nPlanes) {
        this.nPlanes = nPlanes;
        this.normals = new double[nPlanes][];
        for (int i = 0; i < nPlanes; ++i) {
            this.normals[i] = new double[this.n];
        }
        this.ms = new double[nPlanes];
        this.qR = new boolean[this.n * nPlanes];
        this.qL = new boolean[this.n * nPlanes];
        this.inNodes.clear();
        this.inSubtrees.clear();
        this.outNodes.clear();
        this.outSubtrees.clear();
        this.activeStack.clear();
        this.psStack.clear();
        this.tree.realMin(this.xmin);
        this.tree.realMax(this.xmax);
        Arrays.fill(this.getActiveArray(0), true);
    }

    private boolean[] getActiveArray(int i) {
        if (i >= this.activeStack.size()) {
            this.activeStack.add(new boolean[this.nPlanes]);
            this.psStack.add(new boolean[this.nPlanes]);
        }
        return this.activeStack.get(i);
    }

    private boolean[] getPsArray(int i) {
        return this.psStack.get(i);
    }

    private void addAll(KDTreeNode<T> node, ArrayList<KDTreeNode<T>> list) {
        list.add(node);
    }

    private boolean allAbove(int i) {
        double[] normal = this.normals[i];
        double dot = 0.0;
        for (int d = 0; d < this.n; ++d) {
            dot += normal[d] * (normal[d] >= 0.0 ? this.xmin[d] : this.xmax[d]);
        }
        return dot >= this.ms[i];
    }

    private boolean allBelow(int i) {
        double[] normal = this.normals[i];
        double dot = 0.0;
        for (int d = 0; d < this.n; ++d) {
            dot += normal[d] * (normal[d] < 0.0 ? this.xmin[d] : this.xmax[d]);
        }
        return dot < this.ms[i];
    }

    private void clipSubtree(KDTreeNode<T> current, boolean[] ps, boolean[] qs, int qoff, int recursionDepth) {
        boolean[] active = this.getActiveArray(recursionDepth);
        boolean[] stillActive = this.getActiveArray(recursionDepth + 1);
        System.arraycopy(active, 0, stillActive, 0, this.nPlanes);
        boolean noneActive = true;
        for (int i = 0; i < this.nPlanes; ++i) {
            if (!active[i]) continue;
            if (ps[i] && qs[qoff + i] && this.allAbove(i)) {
                stillActive[i] = false;
                continue;
            }
            noneActive = false;
            if (ps[i] || qs[qoff + i] || !this.allBelow(i)) continue;
            this.addAll(current, this.outSubtrees);
            return;
        }
        if (noneActive) {
            this.addAll(current, this.inSubtrees);
        } else {
            this.clip(current, recursionDepth + 1);
        }
    }

    private void clip(KDTreeNode<T> current, int recursionDepth) {
        int sd = current.getSplitDimension();
        double sc = current.getSplitCoordinate();
        boolean[] active = this.getActiveArray(recursionDepth);
        boolean[] ps = this.getPsArray(recursionDepth);
        boolean p = true;
        for (int i = 0; i < this.nPlanes; ++i) {
            if (!active[i]) continue;
            double[] normal = this.normals[i];
            double dot = 0.0;
            for (int d = 0; d < this.n; ++d) {
                dot += current.getDoublePosition(d) * normal[d];
            }
            ps[i] = dot >= this.ms[i];
            p &= ps[i];
        }
        if (p) {
            this.inNodes.add(current);
        } else {
            this.outNodes.add(current);
        }
        int qoff = sd * this.nPlanes;
        if (current.left != null) {
            double max = this.xmax[sd];
            this.xmax[sd] = sc;
            this.clipSubtree(current.left, ps, this.qL, qoff, recursionDepth);
            this.xmax[sd] = max;
        }
        if (current.right != null) {
            double min = this.xmin[sd];
            this.xmin[sd] = sc;
            this.clipSubtree(current.right, ps, this.qR, qoff, recursionDepth);
            this.xmin[sd] = min;
        }
    }
}

