/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.minimaven;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.tools.ToolProvider;
import org.scijava.minimaven.JarClassLoader;
import org.scijava.util.ClassUtils;
import org.scijava.util.FileUtils;
import org.scijava.util.ProcessUtils;

public class JavaCompiler {
    protected PrintStream err;
    protected PrintStream out;
    protected static Method javac;
    private static final String CLASS_NAME = "com.sun.tools.javac.Main";
    private static String quotables;

    public JavaCompiler(PrintStream err, PrintStream out) {
        this.err = err;
        this.out = out;
    }

    public void call(String[] arguments, boolean verbose) throws CompileError {
        this.call(arguments, verbose, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(String[] arguments, boolean verbose, boolean debug) throws CompileError {
        JavaCompiler javaCompiler = this;
        synchronized (javaCompiler) {
            try {
                javax.tools.JavaCompiler sysc = ToolProvider.getSystemJavaCompiler();
                if (sysc != null) {
                    if (debug) {
                        this.err.print("Found tools compiler: " + sysc.getClass());
                        this.err.print(ClassUtils.getLocation(sysc.getClass()));
                    }
                    sysc.run(null, this.out, this.err, arguments);
                    return;
                }
                if (verbose) {
                    this.err.println("No javax.tools.JavaCompiler available. Checking for explicit javac.");
                }
                if (javac == null) {
                    JarClassLoader loader = JavaCompiler.discoverJavac();
                    Class<?> main = loader == null ? Thread.currentThread().getContextClassLoader().loadClass(CLASS_NAME) : loader.forceLoadClass(CLASS_NAME);
                    Class[] argsType = new Class[]{arguments.getClass(), PrintWriter.class};
                    javac = main.getMethod("compile", argsType);
                }
                PrintWriter writer = new PrintWriter(this.err);
                Object result = javac.invoke(null, arguments, writer);
                ((Writer)writer).flush();
                if (!result.equals(new Integer(0))) {
                    throw new CompileError(result);
                }
                return;
            }
            catch (CompileError e) {
                throw e;
            }
            catch (Exception e) {
                if (verbose) {
                    e.printStackTrace(this.err);
                    this.err.println("Could not find javac " + e + ", falling back to system javac");
                }
            }
        }
        String[] newArguments = new String[arguments.length + 1];
        newArguments[0] = "javac";
        System.arraycopy(arguments, 0, newArguments, 1, arguments.length);
        try {
            this.execute(newArguments, new File("."), verbose);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not even fall back  to javac in the PATH", e);
        }
    }

    protected void execute(String[] args, File dir, boolean verbose) throws IOException {
        if (verbose) {
            String output = "Executing:";
            for (int i = 0; i < args.length; ++i) {
                output = output + " '" + args[i] + "'";
            }
            this.err.println(output);
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = JavaCompiler.quoteArg(args[i]);
            }
            if (args[0].startsWith("../")) {
                args[0] = new File(dir, args[0]).getAbsolutePath();
            }
        }
        ProcessUtils.exec((File)dir, (PrintStream)this.err, (PrintStream)this.out, (String[])args);
    }

    public static String quoteArg(String arg) {
        return JavaCompiler.quoteArg(arg, quotables);
    }

    public static String quoteArg(String arg, String quotables) {
        String result = arg;
        for (int j = 0; j < result.length(); ++j) {
            char c = result.charAt(j);
            if (quotables.indexOf(c) < 0) continue;
            String replacement = c == '\"' ? (System.getenv("MSYSTEM") != null ? "\\" + c : "'" + c + "'") : "\"" + c + "\"";
            result = result.substring(0, j) + replacement + result.substring(j + 1);
            j += replacement.length() - 1;
        }
        return result;
    }

    protected static JarClassLoader discoverJavac() throws IOException {
        String ijDir = System.getProperty("ij.dir");
        if (ijDir == null) {
            return null;
        }
        File jars = new File(ijDir, "jars");
        File[] javacVersions = FileUtils.getAllVersions((File)jars, (String)"javac.jar");
        if (javacVersions.length == 0) {
            System.err.println("No javac.jar found (looked in " + jars + ")!");
            return null;
        }
        long newest = Long.MIN_VALUE;
        File javac = null;
        for (File file : javacVersions) {
            long mtime = file.lastModified();
            if (newest >= mtime) continue;
            newest = mtime;
            javac = file;
        }
        return new JarClassLoader(javac == null ? null : javac.getPath());
    }

    static {
        quotables = " \"'";
    }

    public static class CompileError
    extends Exception {
        private static final long serialVersionUID = 1L;
        protected Object result;

        public CompileError(Object result) {
            super("Compile error: " + result);
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

