/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.AbstractCursorInt;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.IntervalIndexer;

public abstract class AbstractArrayCursor<T extends NativeType<T>>
extends AbstractCursorInt<T> {
    protected final int offset;
    protected final int size;
    protected final T type;
    protected final ArrayImg<T, ?> img;
    protected final int lastIndex;

    protected AbstractArrayCursor(AbstractArrayCursor<T> cursor) {
        super(cursor.numDimensions());
        this.img = cursor.img;
        this.type = this.img.createLinkedType();
        this.offset = cursor.offset;
        this.size = cursor.size;
        this.lastIndex = cursor.lastIndex;
        this.type.updateIndex(cursor.type.getIndex());
        this.type.updateContainer(this);
        this.reset();
    }

    public AbstractArrayCursor(ArrayImg<T, ?> img, int offset, int size) {
        super(img.numDimensions());
        this.type = img.createLinkedType();
        this.img = img;
        this.lastIndex = offset + size - 1;
        this.offset = offset;
        this.size = size;
        this.reset();
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.type.getIndex() < this.lastIndex;
    }

    @Override
    public void jumpFwd(long steps) {
        this.type.incIndex((int)steps);
    }

    @Override
    public void fwd() {
        this.type.incIndex();
    }

    @Override
    public void reset() {
        this.type.updateIndex(this.offset - 1);
        this.type.updateContainer(this);
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public int getIntPosition(int dim) {
        return IntervalIndexer.indexToPosition(this.type.getIndex(), this.img.dim, dim);
    }

    @Override
    public void localize(int[] position) {
        IntervalIndexer.indexToPosition(this.type.getIndex(), this.img.dim, position);
    }
}

