/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.scijava.ui.swing.script.EditorPane;
import org.scijava.ui.swing.script.TextEditor;

public class TextEditorTab
extends JSplitPane {
    protected final EditorPane editorPane;
    protected final JTextArea screen = new JTextArea();
    protected final JScrollPane scroll;
    protected boolean showingErrors;
    private TextEditor.Executer executer;
    private final JButton runit;
    private final JButton killit;
    private final JButton toggleErrors;
    private final TextEditor textEditor;

    public TextEditorTab(final TextEditor textEditor) {
        super(0);
        super.setResizeWeight(0.813953488372093);
        this.textEditor = textEditor;
        this.editorPane = new EditorPane();
        this.screen.setEditable(false);
        this.screen.setLineWrap(true);
        this.screen.setFont(new Font("Courier", 0, 12));
        JPanel bottom = new JPanel();
        bottom.setLayout(new GridBagLayout());
        GridBagConstraints bc = new GridBagConstraints();
        bc.gridx = 0;
        bc.gridy = 0;
        bc.weightx = 0.0;
        bc.weighty = 0.0;
        bc.anchor = 18;
        bc.fill = 0;
        this.runit = new JButton("Run");
        this.runit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                textEditor.runText();
            }
        });
        bottom.add((Component)this.runit, bc);
        bc.gridx = 1;
        this.killit = new JButton("Kill");
        this.killit.setEnabled(false);
        this.killit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextEditorTab.this.kill();
            }
        });
        bottom.add((Component)this.killit, bc);
        bc.gridx = 2;
        bc.fill = 2;
        bc.weightx = 1.0;
        bottom.add((Component)new JPanel(), bc);
        bc.gridx = 3;
        bc.fill = 0;
        bc.weightx = 0.0;
        bc.anchor = 12;
        this.toggleErrors = new JButton("Show Errors");
        this.toggleErrors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextEditorTab.this.toggleErrors();
            }
        });
        bottom.add((Component)this.toggleErrors, bc);
        bc.gridx = 4;
        bc.fill = 0;
        bc.weightx = 0.0;
        bc.anchor = 12;
        JButton clear = new JButton("Clear");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TextEditorTab.this.getScreen().setText("");
            }
        });
        bottom.add((Component)clear, bc);
        bc.gridx = 0;
        bc.gridy = 1;
        bc.anchor = 18;
        bc.fill = 1;
        bc.weightx = 1.0;
        bc.weighty = 1.0;
        bc.gridwidth = 5;
        this.screen.setEditable(false);
        this.screen.setLineWrap(true);
        Font font = new Font("Courier", 0, 12);
        this.screen.setFont(font);
        this.scroll = new JScrollPane(this.screen);
        this.scroll.setPreferredSize(new Dimension(600, 80));
        bottom.add((Component)this.scroll, bc);
        super.setTopComponent((Component)this.editorPane.wrappedInScrollbars());
        super.setBottomComponent(bottom);
    }

    public void prepare() {
        this.editorPane.setEditable(false);
        this.runit.setEnabled(false);
        this.killit.setEnabled(true);
    }

    public void restore() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextEditorTab.this.editorPane.setEditable(true);
                TextEditorTab.this.runit.setEnabled(true);
                TextEditorTab.this.killit.setEnabled(false);
                TextEditorTab.this.setExecutor(null);
            }
        });
    }

    public void toggleErrors() {
        boolean bl = this.showingErrors = !this.showingErrors;
        if (this.showingErrors) {
            this.toggleErrors.setText("Show Output");
            this.scroll.setViewportView(this.textEditor.getErrorScreen());
        } else {
            this.toggleErrors.setText("Show Errors");
            this.scroll.setViewportView(this.screen);
        }
    }

    public void showErrors() {
        if (!this.showingErrors) {
            this.toggleErrors();
        } else if (this.scroll.getViewport().getView() == null) {
            this.scroll.setViewportView(this.textEditor.getErrorScreen());
        }
    }

    public void showOutput() {
        if (this.showingErrors) {
            this.toggleErrors();
        }
    }

    public JTextArea getScreen() {
        return this.showingErrors ? this.textEditor.getErrorScreen() : this.screen;
    }

    boolean isExecuting() {
        return null != this.getExecuter();
    }

    public final String getTitle() {
        return (this.editorPane.fileChanged() ? "*" : "") + this.editorPane.getFileName() + (this.isExecuting() ? " (Running)" : "");
    }

    protected void kill() {
        if (null == this.getExecuter()) {
            return;
        }
        this.getExecuter().interrupt();
        final long now = System.currentTimeMillis();
        new Thread(){
            {
                this.setPriority(5);
            }

            @Override
            public void run() {
                while (System.currentTimeMillis() - now < 3000L) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (null != TextEditorTab.this.getExecuter()) {
                    TextEditorTab.this.getExecuter().obliterate();
                }
                TextEditorTab.this.restore();
            }
        }.start();
    }

    public TextEditor.Executer getExecuter() {
        return this.executer;
    }

    public void setExecutor(TextEditor.Executer executer) {
        this.executer = executer;
    }

    public JTextComponent getEditorPane() {
        return this.editorPane;
    }
}

