/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fife.rsta.ac.LanguageSupport;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptLanguage;
import org.scijava.service.Service;
import org.scijava.ui.swing.script.LanguageSupportPlugin;
import org.scijava.ui.swing.script.LanguageSupportService;

@Plugin(type=Service.class)
public class DefaultLanguageSupportService
extends AbstractSingletonService<LanguageSupportPlugin>
implements LanguageSupportService {
    Map<String, LanguageSupport> languageSupports = null;

    @Override
    public LanguageSupport getLanguageSupport(ScriptLanguage language) {
        if (language == null) {
            return null;
        }
        String name = language.getLanguageName().toLowerCase();
        return this.languageSupports().get(name);
    }

    @Override
    public Class<LanguageSupportPlugin> getPluginType() {
        return LanguageSupportPlugin.class;
    }

    private Map<String, LanguageSupport> languageSupports() {
        if (this.languageSupports == null) {
            this.initLanguageSupportPlugins();
        }
        return this.languageSupports;
    }

    private synchronized void initLanguageSupportPlugins() {
        if (this.languageSupports != null) {
            return;
        }
        HashMap<String, LanguageSupportPlugin> map = new HashMap<String, LanguageSupportPlugin>();
        for (LanguageSupportPlugin instance : this.getInstances()) {
            map.put(instance.getLanguageName(), instance);
        }
        this.languageSupports = Collections.unmodifiableMap(map);
    }
}

