/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.rotate;

import net.imagej.Dataset;
import net.imagej.Extents;
import net.imagej.ImgPlus;
import net.imagej.Position;
import net.imagej.plugins.commands.imglib.OutputAlgorithm;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import org.scijava.util.RealRect;

public class XYFlipper
implements OutputAlgorithm {
    private final Dataset dataset;
    private final RealRect bounds;
    private final FlipCoordinateTransformer flipper;
    private final String errMessage = "No error";
    private Img<? extends RealType<?>> outputImage;
    private long[] inputDimensions;
    private RandomAccess<? extends RealType<?>> inputAccessor;
    private RandomAccess<? extends RealType<?>> outputAccessor;

    public XYFlipper(Dataset dataset, RealRect bounds, FlipCoordinateTransformer flipper) {
        this.dataset = dataset;
        this.bounds = bounds;
        this.flipper = flipper;
    }

    @Override
    public boolean checkInput() {
        ImgPlus inputImage = this.dataset.getImgPlus();
        this.inputDimensions = new long[inputImage.numDimensions()];
        inputImage.dimensions(this.inputDimensions);
        long[] outputDimensions = this.flipper.calcOutputDimensions(this.inputDimensions);
        this.outputImage = inputImage.factory().create(outputDimensions, inputImage.firstElement());
        return true;
    }

    @Override
    public String getErrorMessage() {
        return "No error";
    }

    @Override
    public boolean process() {
        long rh;
        long rw;
        long ry;
        long rx;
        ImgPlus inputImage = this.dataset.getImgPlus();
        this.inputAccessor = inputImage.randomAccess();
        this.outputAccessor = this.outputImage.randomAccess();
        long width = this.inputDimensions[0];
        long height = this.inputDimensions[1];
        if (this.flipper.isShapePreserving() && this.bounds.width > 0.0 && this.bounds.height > 0.0) {
            rx = (long)this.bounds.x;
            ry = (long)this.bounds.y;
            rw = (long)this.bounds.width;
            rh = (long)this.bounds.height;
        } else {
            rx = 0L;
            ry = 0L;
            rw = width;
            rh = height;
        }
        long[] planeDims = new long[inputImage.numDimensions() - 2];
        for (int i = 0; i < planeDims.length; ++i) {
            planeDims[i] = this.inputDimensions[i + 2];
        }
        Extents extents = new Extents(planeDims);
        Position planePos = extents.createPosition();
        if (planeDims.length == 0) {
            this.processPlane(planePos, rx, ry, rw, rh);
        } else {
            while (planePos.hasNext()) {
                planePos.fwd();
                this.processPlane(planePos, rx, ry, rw, rh);
            }
        }
        return true;
    }

    public Img<? extends RealType<?>> getResult() {
        return this.outputImage;
    }

    private void processPlane(Position planePos, long rx, long ry, long rw, long rh) {
        long[] inputPosition = new long[planePos.numDimensions() + 2];
        long[] outputPosition = new long[planePos.numDimensions() + 2];
        for (int i = 2; i < inputPosition.length; ++i) {
            inputPosition[i] = planePos.getLongPosition(i - 2);
        }
        for (long y = ry; y < ry + rh; ++y) {
            inputPosition[1] = y;
            long x = rx;
            while (x < rx + rw) {
                inputPosition[0] = x++;
                this.flipper.calcOutputPosition(this.inputDimensions, inputPosition, outputPosition);
                this.inputAccessor.setPosition(inputPosition);
                this.outputAccessor.setPosition(outputPosition);
                double value = ((RealType)this.inputAccessor.get()).getRealDouble();
                ((RealType)this.outputAccessor.get()).setReal(value);
            }
        }
    }

    static interface FlipCoordinateTransformer {
        public long[] calcOutputDimensions(long[] var1);

        public void calcOutputPosition(long[] var1, long[] var2, long[] var3);

        public boolean isShapePreserving();
    }
}

