/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.io;

import io.scif.services.DatasetIOService;
import java.io.IOException;
import net.imagej.Dataset;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.log.LogService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, menu={@Menu(label="File", weight=0.0, mnemonic=102), @Menu(label="Revert", weight=20.0, mnemonic=118, accelerator="^R")}, attrs={@Attr(name="no-legacy")})
public class RevertImage
extends ContextCommand {
    @Parameter
    private LogService log;
    @Parameter
    private DatasetIOService datasetIOService;
    @Parameter
    private UIService uiService;
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;

    public void run() {
        try {
            this.datasetIOService.revert(this.dataset);
        }
        catch (IOException exc) {
            this.log.error((Throwable)exc);
            this.uiService.showDialog(exc.getMessage(), DialogPrompt.MessageType.ERROR_MESSAGE);
        }
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }
}

