/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.widgets;

import com.twosigma.beaker.widgets.ValueWidget;
import com.twosigma.beaker.widgets.bools.Checkbox;
import com.twosigma.beaker.widgets.floats.FloatSlider;
import com.twosigma.beaker.widgets.integers.IntSlider;
import com.twosigma.beaker.widgets.selections.Dropdown;
import com.twosigma.beaker.widgets.strings.Text;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractiveBase {
    private static final Logger logger = LoggerFactory.getLogger(InteractiveBase.class);

    protected static List<ValueWidget<?>> widgetsFromAbbreviations(Object ... input) {
        ArrayList ret = new ArrayList();
        for (Object param : input) {
            ValueWidget<?> widget = InteractiveBase.getWidgetFromAbbrev(param);
            if (widget == null) {
                String text = "";
                text = input != null && input[0] != null ? input.getClass().getSimpleName() : "null";
                throw new RuntimeException(text + " cannot be transformed to a widget");
            }
            if (!(widget instanceof ValueWidget)) {
                throw new RuntimeException(input.getClass().getSimpleName() + " is not a ValueWidget");
            }
            ret.add(widget);
        }
        logger.info("total " + ret.size() + " widgets was created");
        return ret;
    }

    protected static ValueWidget<?> getWidgetFromAbbrev(Object ... input) {
        Dropdown ret = null;
        if (input != null && input.length > 0) {
            ret = InteractiveBase.widgetFromTuple(input);
            if (ret == null) {
                ret = InteractiveBase.widgetFromSingleValue(input[0]);
            }
            if (ret == null) {
                ret = InteractiveBase.widgetFromIterable(input[0]);
            }
        }
        return ret;
    }

    protected static ValueWidget<?> widgetFromTuple(Object ... input) {
        ValueWidget ret = null;
        if (input != null && input.length > 0) {
            boolean isFloat = InteractiveBase.isFloat(input[0]);
            boolean isInt = InteractiveBase.isInt(input[0]);
            if (input.length > 2) {
                if (isFloat) {
                    Double[] minMaxValue = InteractiveBase.getDoubleArray(InteractiveBase.getMinMaxValue((Double)input[0], (Double)input[1], null));
                    FloatSlider witget = new FloatSlider();
                    witget.setMin(minMaxValue[0]);
                    witget.setMax(minMaxValue[1]);
                    witget.setValue(minMaxValue[2]);
                    ret = witget;
                } else if (isInt) {
                    Integer[] minMaxValue = InteractiveBase.getIntArray(InteractiveBase.getMinMaxValue((Integer)input[0], (Integer)input[1], null));
                    IntSlider witget = new IntSlider();
                    witget.setMin(minMaxValue[0]);
                    witget.setMax(minMaxValue[1]);
                    witget.setValue(minMaxValue[2]);
                    ret = witget;
                }
            } else if (input.length > 3) {
                if (isFloat) {
                    Double step = (Double)input[2];
                    if ((Double)input[2] <= 0.0) {
                        throw new RuntimeException("step must be >= 0, not " + step);
                    }
                    Double[] minMaxValue = InteractiveBase.getDoubleArray(InteractiveBase.getMinMaxValue((Double)input[0], (Double)input[1], null));
                    FloatSlider witget = new FloatSlider();
                    witget.setMin(minMaxValue[0]);
                    witget.setMax(minMaxValue[1]);
                    witget.setValue(minMaxValue[2]);
                    witget.setStep(step);
                    ret = witget;
                } else if (isInt) {
                    Integer step = (Integer)input[2];
                    if ((Integer)input[2] <= 0) {
                        throw new RuntimeException("step must be >= 0, not " + step);
                    }
                    Integer[] minMaxValue = InteractiveBase.getIntArray(InteractiveBase.getMinMaxValue((Integer)input[0], (Integer)input[1], null));
                    IntSlider witget = new IntSlider();
                    witget.setMin(minMaxValue[0]);
                    witget.setMax(minMaxValue[1]);
                    witget.setValue(minMaxValue[2]);
                    witget.setStep(step);
                    ret = witget;
                }
            }
        }
        return ret;
    }

    protected static ValueWidget<?> widgetFromSingleValue(Object o) {
        ValueWidget ret = null;
        if (o instanceof String) {
            Text witget = new Text();
            witget.setValue((String)o);
            ret = witget;
        } else if (o instanceof Boolean) {
            Checkbox witget = new Checkbox();
            witget.setValue((Boolean)o);
            ret = witget;
        } else if (InteractiveBase.isInt(o)) {
            Integer value = (Integer)o;
            Integer[] result = InteractiveBase.getIntArray(InteractiveBase.getMinMaxValue(null, null, value));
            IntSlider witget = new IntSlider();
            witget.setMin(result[0]);
            witget.setMax(result[1]);
            witget.setValue(value);
            ret = witget;
        } else if (InteractiveBase.isFloat(o)) {
            Double value = (Double)o;
            Double[] result = InteractiveBase.getDoubleArray(InteractiveBase.getMinMaxValue(null, null, value));
            FloatSlider witget = new FloatSlider();
            witget.setMin(result[0]);
            witget.setMax(result[1]);
            witget.setValue(value);
            ret = witget;
        }
        return ret;
    }

    protected static Dropdown widgetFromIterable(Object o) {
        Object value;
        Dropdown ret = null;
        if (o instanceof Collection) {
            value = (Object[])o;
            ret = new Dropdown();
            ret.setOptions(value);
        }
        if (o instanceof Object[]) {
            value = (Object[])o;
            ret = new Dropdown();
            ret.setOptions(value);
        } else if (o instanceof Map) {
            value = (Map)o;
            ret = new Dropdown();
            ret.setOptions(value.values());
        } else {
            value = new ArrayList(1);
            value.add(o);
            ret = new Dropdown();
            ret.setOptions(value);
        }
        return ret;
    }

    protected static Number[] getMinMaxValue(Number min, Number max, Number value) {
        Number[] ret = new Number[3];
        if (value == null) {
            if (min == null || max == null) {
                throw new RuntimeException("unable to infer range, value from: (" + min + ", " + max + ", " + value + ")");
            }
            if (InteractiveBase.isAllInt(min, max)) {
                int diff = (Integer)max - (Integer)min;
                ret[2] = Integer.valueOf((Integer)min) + diff / 2;
            } else {
                double diff = (Double)max - (Double)min;
                ret[2] = Double.valueOf((Double)min) + diff / 2.0;
            }
            ret[0] = min;
            ret[1] = max;
        } else {
            Number[] vrange = new Number[2];
            double dValue = value instanceof Integer ? ((Integer)value).doubleValue() : ((Double)value).doubleValue();
            boolean isInt = InteractiveBase.isAllInt(min, max, value);
            if (dValue == 0.0) {
                if (isInt) {
                    vrange[0] = (int)dValue;
                    vrange[1] = (int)dValue + 1;
                } else {
                    vrange[0] = dValue;
                    vrange[1] = dValue + 1.0;
                }
            } else if (dValue > 0.0) {
                if (isInt) {
                    vrange[0] = (int)dValue * -1;
                    vrange[1] = (int)dValue * 3;
                } else {
                    vrange[0] = dValue * -1.0;
                    vrange[1] = dValue * 3.0;
                }
            } else if (isInt) {
                vrange[0] = (int)(dValue * 3.0);
                vrange[1] = (int)(dValue * -1.0);
            } else {
                vrange[0] = dValue * 3.0;
                vrange[1] = dValue * -1.0;
            }
            if (min == null) {
                ret[0] = vrange[0];
            }
            if (max == null) {
                ret[1] = vrange[1];
            }
            ret[2] = value;
        }
        return ret;
    }

    protected static Integer[] getIntArray(Number[] input) {
        return (Integer[])Arrays.copyOf(input, input.length, Integer[].class);
    }

    protected static Double[] getDoubleArray(Number[] input) {
        return (Double[])Arrays.copyOf(input, input.length, Double[].class);
    }

    protected static boolean isAllInt(Number ... o) {
        boolean ret = true;
        for (Number number : o) {
            if (number != null && !(ret = InteractiveBase.isInt(number))) break;
        }
        return ret;
    }

    protected static boolean isInt(Object o) {
        return o instanceof Integer || o instanceof Short || o instanceof Byte;
    }

    protected static boolean isFloat(Object o) {
        return o instanceof Double || o instanceof Float;
    }
}

