/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.table.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beaker.table.TableDisplay;
import com.twosigma.beaker.table.serializer.ObservableTableDisplaySerializer;
import java.io.IOException;
import java.util.List;

public class TableDisplaySerializer
extends ObservableTableDisplaySerializer<TableDisplay> {
    public int ROWS_LIMIT = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(TableDisplay value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        TableDisplay tableDisplay = value;
        synchronized (tableDisplay) {
            jgen.writeStartObject();
            super.serialize(value, jgen);
            jgen.writeObjectField("type", (Object)"TableDisplay");
            jgen.writeObjectField("columnNames", value.getColumnNames());
            jgen.writeObjectField("types", value.getTypes());
            jgen.writeObjectField("subtype", (Object)value.getSubtype());
            jgen.writeObjectField("stringFormatForTimes", (Object)value.getStringFormatForTimes());
            jgen.writeObjectField("stringFormatForType", value.getStringFormatForType());
            jgen.writeObjectField("stringFormatForColumn", value.getStringFormatForColumn());
            jgen.writeObjectField("rendererForType", value.getRendererForType());
            jgen.writeObjectField("rendererForColumn", value.getRendererForColumn());
            jgen.writeObjectField("alignmentForType", value.getAlignmentForType());
            jgen.writeObjectField("alignmentForColumn", value.getAlignmentForColumn());
            jgen.writeObjectField("columnsFrozen", value.getColumnsFrozen());
            jgen.writeObjectField("columnsFrozenRight", value.getColumnsFrozenRight());
            jgen.writeObjectField("columnsVisible", value.getColumnsVisible());
            jgen.writeObjectField("columnOrder", value.getColumnOrder());
            jgen.writeObjectField("cellHighlighters", value.getCellHighlighters());
            jgen.writeObjectField("tooltips", value.getTooltips());
            jgen.writeObjectField("dataFontSize", (Object)value.getDataFontSize());
            jgen.writeObjectField("headerFontSize", (Object)value.getHeaderFontSize());
            jgen.writeObjectField("fontColor", value.getFontColor());
            if (value.getFilteredValues() != null) {
                jgen.writeObjectField("filteredValues", value.getFilteredValues());
            }
            jgen.writeBooleanField("headersVertical", value.getHeadersVertical().booleanValue());
            jgen.writeObjectField("hasIndex", (Object)value.getHasIndex());
            jgen.writeObjectField("timeZone", (Object)value.getTimeZone());
            List<List<?>> values = value.getValues();
            if (values.size() > this.ROWS_LIMIT) {
                jgen.writeObjectField("values", values.subList(0, 1000));
                jgen.writeBooleanField("tooManyRows", true);
                jgen.writeObjectField("rowLength", (Object)values.size());
                jgen.writeObjectField("rowLimit", (Object)this.ROWS_LIMIT);
            } else {
                jgen.writeObjectField("values", values);
                jgen.writeBooleanField("tooManyRows", false);
            }
            jgen.writeEndObject();
        }
    }
}

