/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beaker.BeakerCodeCell;
import com.twosigma.beaker.evaluator.InternalVariable;
import com.twosigma.beaker.jupyter.comm.Comm;
import com.twosigma.beaker.jupyter.comm.TargetNamesEnum;
import com.twosigma.beaker.jvm.object.SimpleEvaluationObject;
import com.twosigma.beaker.jvm.serialization.BasicObjectSerializer;
import com.twosigma.beaker.jvm.serialization.BeakerObjectConverter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;

public class NamespaceClient {
    private static Map<String, NamespaceClient> nsClients = new ConcurrentHashMap<String, NamespaceClient>();
    private static String currentSession;
    private static Map<String, SynchronousQueue<Object>> messagePool;
    private ObjectMapper objectMapper = new ObjectMapper();
    private BeakerObjectConverter objectSerializer = new BasicObjectSerializer();
    private SimpleEvaluationObject currentCeo = null;
    private Comm autotranslationComm = null;
    private Comm codeCellsComm = null;

    public synchronized void showProgressUpdate(String message, int progress) {
        SimpleEvaluationObject seo = InternalVariable.getSimpleEvaluationObject();
        seo.structuredUpdate(message, progress);
    }

    public SimpleEvaluationObject getOutputObj() {
        return this.currentCeo;
    }

    public synchronized void setOutputObj(SimpleEvaluationObject input) {
        this.currentCeo = input;
    }

    public static synchronized NamespaceClient getBeaker() {
        if (currentSession != null) {
            return nsClients.get(currentSession);
        }
        return null;
    }

    public static synchronized NamespaceClient getBeaker(String session) {
        currentSession = session;
        if (!nsClients.containsKey(session)) {
            nsClients.put(session, new NamespaceClient());
        }
        return nsClients.get(currentSession);
    }

    public static synchronized void delBeaker(String sessionId) {
        nsClients.remove(sessionId);
        currentSession = null;
    }

    public synchronized Object set(String name, Object value) throws IOException {
        Comm c = this.getAutotranslationComm();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", name);
        data.put("value", this.getJson(value));
        data.put("sync", true);
        c.setData(data);
        c.send();
        return value;
    }

    protected String getJson(Object value) throws IOException {
        StringWriter sw = new StringWriter();
        JsonGenerator jgen = this.objectMapper.getFactory().createGenerator((Writer)sw);
        this.objectSerializer.writeObject(value, jgen, true);
        jgen.flush();
        sw.flush();
        return sw.toString();
    }

    public Object setFast(String name, Object value) {
        throw new RuntimeException("This option is not implemented now");
    }

    public Object unset(String name) {
        throw new RuntimeException("This option is not implemented now");
    }

    public synchronized Object get(String name) {
        throw new RuntimeException("This option is not implemented now");
    }

    public static SynchronousQueue<Object> getMessageQueue(String channel) {
        SynchronousQueue<Object> result = messagePool.get(channel);
        if (result == null) {
            result = new SynchronousQueue();
            messagePool.put(channel, result);
        }
        return result;
    }

    protected Comm getAutotranslationComm() {
        if (this.autotranslationComm == null) {
            this.autotranslationComm = new Comm(TargetNamesEnum.BEAKER_AUTOTRANSLATION);
            this.autotranslationComm.open();
        }
        return this.autotranslationComm;
    }

    protected Comm getCodeCellsComm() {
        if (this.codeCellsComm == null) {
            this.codeCellsComm = new Comm(TargetNamesEnum.BEAKER_GETCODECELLS);
            this.codeCellsComm.open();
        }
        return this.codeCellsComm;
    }

    public List<BeakerCodeCell> getCodeCells(String tagFilter) throws IOException, InterruptedException {
        Comm c = this.getCodeCellsComm();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", "CodeCells");
        data.put("value", this.getJson(tagFilter));
        c.setData(data);
        c.send();
        Object cells = NamespaceClient.getMessageQueue("CodeCells").take();
        return (List)cells;
    }

    static {
        messagePool = new HashMap<String, SynchronousQueue<Object>>();
    }

    private class ObjectHolder<T> {
        private T value;

        private ObjectHolder() {
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }
}

