/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class FftFilter {
    private int _nx1;
    private int _nx2;
    private int _nx3;
    private int _nh1;
    private int _nh2;
    private int _nh3;
    private int _kh1;
    private int _kh2;
    private int _kh3;
    private int _nfft1;
    private int _nfft2;
    private int _nfft3;
    private FftReal _fft1;
    private FftComplex _fft2;
    private FftComplex _fft3;
    private float[] _h1;
    private float[] _h1fft;
    private float[][] _h2;
    private float[][] _h2fft;
    private float[][][] _h3;
    private float[][][] _h3fft;
    private Extrapolation _extrapolation = Extrapolation.ZERO_VALUE;
    private boolean _filterCaching;

    public FftFilter(float[] h) {
        this((h.length - 1) / 2, h);
    }

    public FftFilter(int kh, float[] h) {
        Check.argument(0 <= kh && kh < h.length, "index kh is valid");
        this._nh1 = h.length;
        this._kh1 = kh;
        this._h1 = ArrayMath.copy(h);
    }

    public FftFilter(float[][] h) {
        this((h[0].length - 1) / 2, (h.length - 1) / 2, h);
    }

    public FftFilter(int kh1, int kh2, float[][] h) {
        Check.argument(0 <= kh1 && kh1 < h[0].length, "index kh1 is valid");
        Check.argument(0 <= kh2 && kh2 < h.length, "index kh2 is valid");
        this._nh1 = h[0].length;
        this._nh2 = h.length;
        this._kh1 = kh1;
        this._kh2 = kh2;
        this._h2 = ArrayMath.copy(h);
    }

    public FftFilter(float[][][] h) {
        this((h[0][0].length - 1) / 2, (h[0].length - 1) / 2, (h.length - 1) / 2, h);
    }

    public FftFilter(int kh1, int kh2, int kh3, float[][][] h) {
        Check.argument(0 <= kh1 && kh1 < h[0][0].length, "index kh1 is valid");
        Check.argument(0 <= kh2 && kh2 < h[0].length, "index kh2 is valid");
        Check.argument(0 <= kh3 && kh3 < h.length, "index kh3 is valid");
        this._nh1 = h[0][0].length;
        this._nh2 = h[0].length;
        this._nh3 = h.length;
        this._kh1 = kh1;
        this._kh2 = kh2;
        this._kh3 = kh3;
        this._h3 = ArrayMath.copy(h);
    }

    public void setExtrapolation(Extrapolation extrapolation) {
        this._extrapolation = extrapolation;
    }

    public void setFilterCaching(boolean filterCaching) {
        this._filterCaching = filterCaching;
    }

    public float[] apply(float[] x) {
        float[] y = new float[x.length];
        this.apply(x, y);
        return y;
    }

    public void apply(float[] x, float[] y) {
        Check.state(this._h1 != null, "1D filter is available");
        int nx1 = x.length;
        this.updateFfts(nx1);
        float[] xfft = new float[this._nfft1 + 2];
        ArrayMath.copy(nx1, x, xfft);
        this.extrapolate(xfft);
        this._fft1.realToComplex(-1, xfft, xfft);
        int nk1 = this._nfft1 / 2 + 1;
        int ik1 = 0;
        int k1r = 0;
        int k1i = 1;
        while (ik1 < nk1) {
            float xr = xfft[k1r];
            float xi = xfft[k1i];
            float hr = this._h1fft[k1r];
            float hi = this._h1fft[k1i];
            xfft[k1r] = xr * hr - xi * hi;
            xfft[k1i] = xr * hi + xi * hr;
            ++ik1;
            k1r += 2;
            k1i += 2;
        }
        if (!this._filterCaching) {
            this._h1fft = null;
        }
        this._fft1.complexToReal(1, xfft, xfft);
        ArrayMath.copy(nx1, xfft, y);
    }

    public float[][] apply(float[][] x) {
        float[][] y = new float[x.length][x[0].length];
        this.apply(x, y);
        return y;
    }

    public void apply(float[][] x, float[][] y) {
        Check.state(this._h2 != null, "2D filter is valid");
        int nx1 = x[0].length;
        int nx2 = x.length;
        this.updateFfts(nx1, nx2);
        float[][] xfft = new float[this._nfft2][this._nfft1 + 2];
        ArrayMath.copy(nx1, nx2, x, xfft);
        this.extrapolate(xfft);
        this._fft1.realToComplex1(-1, this._nfft2, xfft, xfft);
        this._fft2.complexToComplex2(-1, this._nfft1 / 2 + 1, xfft, xfft);
        int nk1 = this._nfft1 / 2 + 1;
        int nk2 = this._nfft2;
        for (int ik2 = 0; ik2 < nk2; ++ik2) {
            float[] x2 = xfft[ik2];
            float[] h2 = this._h2fft[ik2];
            int ik1 = 0;
            int k1r = 0;
            int k1i = 1;
            while (ik1 < nk1) {
                float xr = x2[k1r];
                float xi = x2[k1i];
                float hr = h2[k1r];
                float hi = h2[k1i];
                x2[k1r] = xr * hr - xi * hi;
                x2[k1i] = xr * hi + xi * hr;
                ++ik1;
                k1r += 2;
                k1i += 2;
            }
        }
        if (!this._filterCaching) {
            this._h2fft = null;
        }
        this._fft2.complexToComplex2(1, this._nfft1 / 2 + 1, xfft, xfft);
        this._fft1.complexToReal1(1, this._nfft2, xfft, xfft);
        ArrayMath.copy(nx1, nx2, xfft, y);
    }

    public float[][][] apply(float[][][] x) {
        float[][][] y = new float[x.length][x[0].length][x[0][0].length];
        this.apply(x, y);
        return y;
    }

    public void apply(float[][][] x, float[][][] y) {
        Check.state(this._h3 != null, "3D filter is valid");
        int nx1 = x[0][0].length;
        int nx2 = x[0].length;
        int nx3 = x.length;
        this.updateFfts(nx1, nx2, nx3);
        float[][][] xfft = new float[this._nfft3][this._nfft2][this._nfft1 + 2];
        ArrayMath.copy(nx1, nx2, nx3, x, xfft);
        this.extrapolate(xfft);
        this._fft1.realToComplex1(-1, this._nfft2, this._nfft3, xfft, xfft);
        this._fft2.complexToComplex2(-1, this._nfft1 / 2 + 1, this._nfft3, xfft, xfft);
        this._fft3.complexToComplex3(-1, this._nfft1 / 2 + 1, this._nfft2, xfft, xfft);
        int nk1 = this._nfft1 / 2 + 1;
        int nk2 = this._nfft2;
        int nk3 = this._nfft3;
        for (int ik3 = 0; ik3 < nk3; ++ik3) {
            for (int ik2 = 0; ik2 < nk2; ++ik2) {
                float[] x32 = xfft[ik3][ik2];
                float[] h32 = this._h3fft[ik3][ik2];
                int ik1 = 0;
                int k1r = 0;
                int k1i = 1;
                while (ik1 < nk1) {
                    float xr = x32[k1r];
                    float xi = x32[k1i];
                    float hr = h32[k1r];
                    float hi = h32[k1i];
                    x32[k1r] = xr * hr - xi * hi;
                    x32[k1i] = xr * hi + xi * hr;
                    ++ik1;
                    k1r += 2;
                    k1i += 2;
                }
            }
        }
        if (!this._filterCaching) {
            this._h3fft = null;
        }
        this._fft3.complexToComplex3(1, this._nfft1 / 2 + 1, this._nfft2, xfft, xfft);
        this._fft2.complexToComplex2(1, this._nfft1 / 2 + 1, this._nfft3, xfft, xfft);
        this._fft1.complexToReal1(1, this._nfft2, this._nfft3, xfft, xfft);
        ArrayMath.copy(nx1, nx2, nx3, xfft, y);
    }

    private void updateFfts(int nx1) {
        if (this._fft1 == null || this._h1fft == null || this._nx1 != nx1) {
            this._nx1 = nx1;
            this._nx2 = 0;
            this._nx3 = 0;
            this._nfft1 = FftReal.nfftFast(this._nx1 + this._nh1);
            this._fft1 = new FftReal(this._nfft1);
            this._fft2 = null;
            this._fft3 = null;
            this._h1fft = new float[this._nfft1 + 2];
            this._h2fft = null;
            this._h3fft = null;
            float scale = 1.0f / (float)this._nfft1;
            for (int ih1 = 0; ih1 < this._nh1; ++ih1) {
                int jh1 = ih1 - this._kh1;
                if (jh1 < 0) {
                    jh1 += this._nfft1;
                }
                this._h1fft[jh1] = scale * this._h1[ih1];
            }
            this._fft1.realToComplex(-1, this._h1fft, this._h1fft);
        }
    }

    private void updateFfts(int nx1, int nx2) {
        if (this._fft2 == null || this._h2fft == null || this._nx1 != nx1 || this._nx2 != nx2) {
            this._nx1 = nx1;
            this._nx2 = nx2;
            this._nx3 = 0;
            this._nfft1 = FftReal.nfftFast(this._nx1 + this._nh1);
            this._nfft2 = FftComplex.nfftFast(this._nx2 + this._nh2);
            this._fft1 = new FftReal(this._nfft1);
            this._fft2 = new FftComplex(this._nfft2);
            this._fft3 = null;
            this._h1fft = null;
            this._h2fft = new float[this._nfft2][this._nfft1 + 2];
            this._h3fft = null;
            float scale = 1.0f / (float)this._nfft1 / (float)this._nfft2;
            for (int ih2 = 0; ih2 < this._nh2; ++ih2) {
                int jh2 = ih2 - this._kh2;
                if (jh2 < 0) {
                    jh2 += this._nfft2;
                }
                for (int ih1 = 0; ih1 < this._nh1; ++ih1) {
                    int jh1 = ih1 - this._kh1;
                    if (jh1 < 0) {
                        jh1 += this._nfft1;
                    }
                    this._h2fft[jh2][jh1] = scale * this._h2[ih2][ih1];
                }
            }
            this._fft1.realToComplex1(-1, this._nfft2, this._h2fft, this._h2fft);
            this._fft2.complexToComplex2(-1, this._nfft1 / 2 + 1, this._h2fft, this._h2fft);
        }
    }

    private void updateFfts(int nx1, int nx2, int nx3) {
        if (this._fft3 == null || this._h3fft == null || this._nx1 != nx1 || this._nx2 != nx2 || this._nx3 != nx3) {
            this._nx1 = nx1;
            this._nx2 = nx2;
            this._nx3 = nx3;
            this._nfft1 = FftReal.nfftFast(this._nx1 + this._nh1);
            this._nfft2 = FftComplex.nfftFast(this._nx2 + this._nh2);
            this._nfft3 = FftComplex.nfftFast(this._nx3 + this._nh3);
            this._fft1 = new FftReal(this._nfft1);
            this._fft2 = new FftComplex(this._nfft2);
            this._fft3 = new FftComplex(this._nfft3);
            this._h1fft = null;
            this._h2fft = null;
            this._h3fft = new float[this._nfft3][this._nfft2][this._nfft1 + 2];
            float scale = 1.0f / (float)this._nfft1 / (float)this._nfft2 / (float)this._nfft3;
            for (int ih3 = 0; ih3 < this._nh3; ++ih3) {
                int jh3 = ih3 - this._kh3;
                if (jh3 < 0) {
                    jh3 += this._nfft3;
                }
                for (int ih2 = 0; ih2 < this._nh2; ++ih2) {
                    int jh2 = ih2 - this._kh2;
                    if (jh2 < 0) {
                        jh2 += this._nfft2;
                    }
                    for (int ih1 = 0; ih1 < this._nh1; ++ih1) {
                        int jh1 = ih1 - this._kh1;
                        if (jh1 < 0) {
                            jh1 += this._nfft1;
                        }
                        this._h3fft[jh3][jh2][jh1] = scale * this._h3[ih3][ih2][ih1];
                    }
                }
            }
            this._fft1.realToComplex1(-1, this._nfft2, this._nfft3, this._h3fft, this._h3fft);
            this._fft2.complexToComplex2(-1, this._nfft1 / 2 + 1, this._nfft3, this._h3fft, this._h3fft);
            this._fft3.complexToComplex3(-1, this._nfft1 / 2 + 1, this._nfft2, this._h3fft, this._h3fft);
        }
    }

    private void extrapolate(float[] xfft) {
        if (this._extrapolation == Extrapolation.ZERO_SLOPE) {
            int mr1 = this._nx1 + this._kh1;
            float xr1 = xfft[this._nx1 - 1];
            for (int i1 = this._nx1; i1 < mr1; ++i1) {
                xfft[i1] = xr1;
            }
            int ml1 = this._nfft1 + this._kh1 - this._nh1 + 1;
            float xl1 = xfft[0];
            for (int i1 = ml1; i1 < this._nfft1; ++i1) {
                xfft[i1] = xl1;
            }
        }
    }

    private void extrapolate(float[][] xfft) {
        if (this._extrapolation == Extrapolation.ZERO_SLOPE) {
            for (int i2 = 0; i2 < this._nx2; ++i2) {
                this.extrapolate(xfft[i2]);
            }
            int mr2 = this._nx2 + this._kh2;
            float[] xr2 = xfft[this._nx2 - 1];
            for (int i2 = this._nx2; i2 < mr2; ++i2) {
                ArrayMath.copy(xr2, xfft[i2]);
            }
            int ml2 = this._nfft2 + this._kh2 - this._nh2 + 1;
            float[] xl2 = xfft[0];
            for (int i2 = ml2; i2 < this._nfft2; ++i2) {
                ArrayMath.copy(xl2, xfft[i2]);
            }
        }
    }

    private void extrapolate(float[][][] xfft) {
        if (this._extrapolation == Extrapolation.ZERO_SLOPE) {
            for (int i3 = 0; i3 < this._nx3; ++i3) {
                this.extrapolate(xfft[i3]);
            }
            int mr3 = this._nx3 + this._kh3;
            float[][] xr3 = xfft[this._nx3 - 1];
            for (int i3 = this._nx3; i3 < mr3; ++i3) {
                ArrayMath.copy(xr3, xfft[i3]);
            }
            int ml3 = this._nfft3 + this._kh3 - this._nh3 + 1;
            float[][] xl3 = xfft[0];
            for (int i3 = ml3; i3 < this._nfft3; ++i3) {
                ArrayMath.copy(xl3, xfft[i3]);
            }
        }
    }

    public static enum Extrapolation {
        ZERO_VALUE,
        ZERO_SLOPE;

    }
}

