/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.binary;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imagej.ImgPlus;
import net.imagej.ImgPlusMetadata;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.labeling.Labeling;
import net.imglib2.ops.operation.BinaryOperation;
import net.imglib2.ops.operation.metadata.unary.CopyCalibratedSpace;
import net.imglib2.ops.operation.metadata.unary.CopyImageMetadata;
import net.imglib2.ops.operation.metadata.unary.CopyMetadata;
import net.imglib2.ops.operation.metadata.unary.CopyNamed;
import net.imglib2.ops.operation.metadata.unary.CopySourced;
import net.imglib2.ops.operation.subset.views.ImgPlusView;
import net.imglib2.ops.operation.subset.views.ImgView;
import net.imglib2.ops.operation.subset.views.LabelingView;
import net.imglib2.ops.operation.subset.views.SubsetViews;
import net.imglib2.type.Type;

@Deprecated
public final class IterateBinaryOperation<T extends Type<T>, V extends Type<V>, O extends Type<O>>
implements BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>, RandomAccessibleInterval<O>> {
    private final BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>, RandomAccessibleInterval<O>> m_op;
    private final Interval[] m_in0Intervals;
    private final Interval[] m_in1Intervals;
    private final Interval[] m_outIntervals;
    private final ExecutorService m_service;

    public IterateBinaryOperation(BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>, RandomAccessibleInterval<O>> op, Interval[] in0InIntervals, Interval[] in1Intervals, Interval[] outIntervals, ExecutorService service) {
        this.m_op = op;
        this.m_in0Intervals = in0InIntervals;
        this.m_in1Intervals = in1Intervals;
        this.m_outIntervals = outIntervals;
        this.m_service = service;
    }

    public IterateBinaryOperation(BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>, RandomAccessibleInterval<O>> op, Interval[] in0InIntervals, Interval[] in1Intervals, Interval[] outIntervals) {
        this(op, in0InIntervals, in1Intervals, outIntervals, null);
    }

    public IterateBinaryOperation(BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>, RandomAccessibleInterval<O>> op, Interval[] inInIntervals, Interval[] outIntervals) {
        this(op, inInIntervals, inInIntervals, outIntervals, null);
    }

    public IterateBinaryOperation(BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>, RandomAccessibleInterval<O>> op, Interval[] inInIntervals, Interval[] outIntervals, ExecutorService service) {
        this(op, inInIntervals, inInIntervals, outIntervals, service);
    }

    public IterateBinaryOperation(BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>, RandomAccessibleInterval<O>> op, Interval[] intervals) {
        this(op, intervals, intervals, intervals, null);
    }

    public IterateBinaryOperation(BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>, RandomAccessibleInterval<O>> op, Interval[] intervals, ExecutorService service) {
        this(op, intervals, intervals, intervals, service);
    }

    @Override
    public final RandomAccessibleInterval<O> compute(RandomAccessibleInterval<T> in0, RandomAccessibleInterval<V> in1, RandomAccessibleInterval<O> out) {
        if (this.m_in0Intervals.length != this.m_outIntervals.length || this.m_in0Intervals.length != this.m_in1Intervals.length) {
            throw new IllegalArgumentException("In and out intervals do not match! Most likely an implementation error!");
        }
        Future[] futures = new Future[this.m_in0Intervals.length];
        for (int i = 0; i < this.m_outIntervals.length; ++i) {
            if (Thread.interrupted()) {
                return out;
            }
            OperationTask t = new OperationTask(this.m_op, this.createSubType(in0, this.m_in0Intervals[i]), this.createSubType(in1, this.m_in1Intervals[i]), this.createSubType(out, this.m_outIntervals[i]));
            if (this.m_service != null) {
                if (this.m_service.isShutdown()) {
                    return out;
                }
                futures[i] = this.m_service.submit(t);
                continue;
            }
            t.run();
        }
        if (this.m_service != null) {
            try {
                for (Future f : futures) {
                    if (f.isCancelled()) {
                        return out;
                    }
                    f.get();
                }
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                // empty catch block
            }
        }
        return out;
    }

    private synchronized <TT extends Type<TT>, II extends RandomAccessibleInterval<TT>> II createSubType(II in, Interval i) {
        if (in instanceof Labeling) {
            return (II)((Object)new LabelingView(SubsetViews.iterableSubsetView(in, i), ((Labeling)in).factory()));
        }
        if (in instanceof ImgPlus) {
            ImgPlusView imgPlusView = new ImgPlusView(SubsetViews.iterableSubsetView(in, i), ((ImgPlus)in).factory());
            new CopyMetadata(new CopyNamed(), new CopySourced(), new CopyImageMetadata(), new CopyCalibratedSpace(i)).compute((ImgPlusMetadata)((ImgPlus)in), (ImgPlusMetadata)imgPlusView);
            return (II)((Object)imgPlusView);
        }
        if (in instanceof Img) {
            return (II)((Object)new ImgView(SubsetViews.iterableSubsetView(in, i), ((Img)in).factory()));
        }
        return (II)SubsetViews.iterableSubsetView(in, i);
    }

    @Override
    public BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>, RandomAccessibleInterval<O>> copy() {
        return new IterateBinaryOperation<T, V, O>(this.m_op.copy(), this.m_in0Intervals, this.m_in1Intervals, this.m_outIntervals, this.m_service);
    }

    private class OperationTask
    implements Runnable {
        private final BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>, RandomAccessibleInterval<O>> m_op;
        private final RandomAccessibleInterval<T> m_in1;
        private final RandomAccessibleInterval<V> m_in2;
        private final RandomAccessibleInterval<O> m_out;

        public OperationTask(BinaryOperation<RandomAccessibleInterval<T>, RandomAccessibleInterval<V>, RandomAccessibleInterval<O>> op, RandomAccessibleInterval<T> in1, RandomAccessibleInterval<V> in2, RandomAccessibleInterval<O> out) {
            this.m_in1 = in1;
            this.m_in2 = in2;
            this.m_out = out;
            this.m_op = op.copy();
        }

        @Override
        public void run() {
            this.m_op.compute(this.m_in1, this.m_in2, this.m_out);
        }
    }
}

