/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.img.unary;

import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.list.ListImgFactory;
import net.imglib2.ops.img.UnaryOperationAssignment;
import net.imglib2.ops.operation.UnaryOutputOperation;
import net.imglib2.ops.operation.iterableinterval.unary.MinMax;
import net.imglib2.ops.operation.real.unary.Convert;
import net.imglib2.ops.operation.real.unary.Normalize;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.ValuePair;
import net.imglib2.view.Views;

@Deprecated
public class ImgConvert<I extends RealType<I>, O extends RealType<O> & NativeType<O>>
implements UnaryOutputOperation<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>> {
    private final O m_outType;
    private final I m_inType;
    private final ImgConversionTypes m_conversionType;
    private ImgFactory<O> m_outFactory;

    public ImgConvert(I inType, O outType, ImgConversionTypes type, ImgFactory<O> imgFac) {
        this.m_outType = outType;
        this.m_conversionType = type;
        this.m_inType = inType;
        this.m_outFactory = imgFac;
    }

    @Deprecated
    public ImgConvert(I inType, O outType, ImgConversionTypes type) {
        this.m_outType = outType;
        this.m_conversionType = type;
        this.m_inType = inType;
        this.m_outFactory = new ListImgFactory();
    }

    @Override
    public RandomAccessibleInterval<O> compute(RandomAccessibleInterval<I> img, RandomAccessibleInterval<O> r) {
        IterableInterval iterImg = Views.iterable(img);
        Convert<I, O> convertOp = null;
        switch (this.m_conversionType) {
            case DIRECT: {
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.DIRECT);
                break;
            }
            case DIRECTCLIP: {
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.DIRECTCLIP);
                break;
            }
            case NORMALIZEDIRECT: {
                ValuePair oldMinMax = new MinMax().compute(iterImg);
                double factor = Normalize.normalizationFactor(((RealType)oldMinMax.a).getRealDouble(), ((RealType)oldMinMax.b).getRealDouble(), this.m_inType.getMinValue(), this.m_inType.getMaxValue());
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.SCALE);
                convertOp.setFactor(convertOp.getFactor() / factor);
                convertOp.setInMin(0.0);
                convertOp.setOutMin(0.0);
                break;
            }
            case NORMALIZESCALE: {
                ValuePair oldMinMax = new MinMax().compute(iterImg);
                double factor = Normalize.normalizationFactor(((RealType)oldMinMax.a).getRealDouble(), ((RealType)oldMinMax.b).getRealDouble(), this.m_inType.getMinValue(), this.m_inType.getMaxValue());
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.SCALE);
                convertOp.setFactor(convertOp.getFactor() / factor);
                convertOp.setInMin(((RealType)oldMinMax.a).getRealDouble());
                break;
            }
            case NORMALIZEDIRECTCLIP: {
                ValuePair oldMinMax = new MinMax().compute(iterImg);
                double factor = Normalize.normalizationFactor(((RealType)oldMinMax.a).getRealDouble(), ((RealType)oldMinMax.b).getRealDouble(), this.m_inType.getMinValue(), this.m_inType.getMaxValue());
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.SCALECLIP);
                convertOp.setFactor(convertOp.getFactor() / factor);
                convertOp.setInMin(((RealType)oldMinMax.a).getRealDouble());
                break;
            }
            case SCALE: {
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.SCALE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Normalization type unknown");
            }
        }
        UnaryOperationAssignment<I, O> map = new UnaryOperationAssignment<I, O>(convertOp);
        map.compute(Views.flatIterable(img), Views.flatIterable(r));
        return r;
    }

    @Override
    @Deprecated
    public RandomAccessibleInterval<O> compute(Img<I> img, Img<O> r) {
        this.m_outFactory = r.factory();
        return this.compute(img, r);
    }

    @Override
    public UnaryOutputOperation<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>> copy() {
        return new ImgConvert<RealType, RealType>((RealType)this.m_inType.copy(), (RealType)this.m_outType.copy(), this.m_conversionType, this.m_outFactory);
    }

    @Override
    public Img<O> createEmptyOutput(RandomAccessibleInterval<I> in) {
        return this.m_outFactory.create(in, this.m_outType);
    }

    @Override
    public RandomAccessibleInterval<O> compute(RandomAccessibleInterval<I> in) {
        return this.compute(in, (RandomAccessibleInterval<O>)this.createEmptyOutput(in));
    }

    public static enum ImgConversionTypes {
        DIRECT("Copy"),
        DIRECTCLIP("Clip"),
        SCALE("Scale"),
        NORMALIZESCALE("Normalize and scale"),
        NORMALIZEDIRECT("Normalize"),
        NORMALIZEDIRECTCLIP("Normalize (clipped)");

        private final String m_label;

        public static String[] labelsAsStringArray() {
            ImgConversionTypes[] types = ImgConversionTypes.values();
            String[] res = new String[types.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = types[i].getLabel();
            }
            return res;
        }

        public static ImgConversionTypes getByLabel(String label) {
            for (ImgConversionTypes t : ImgConversionTypes.values()) {
                if (!t.getLabel().equals(label)) continue;
                return t;
            }
            return null;
        }

        private ImgConversionTypes(String label) {
            this.m_label = label;
        }

        public String getLabel() {
            return this.m_label;
        }
    }
}

