/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood.old;

import net.imglib2.AbstractCursor;
import net.imglib2.RandomAccess;

@Deprecated
public class LocalNeighborhoodCursor2<T>
extends AbstractCursor<T> {
    final RandomAccess<T> source;
    private final long[] center;
    private final long[] min;
    private final long[] max;
    private final long span;
    private final long maxCount;
    private final long midCount;
    private long count;

    public LocalNeighborhoodCursor2(RandomAccess<T> source, long[] center, long span) {
        super(source.numDimensions());
        this.source = source;
        this.center = center;
        this.max = new long[this.n];
        this.min = new long[this.n];
        this.span = span;
        this.maxCount = (long)Math.pow(span + 1L + span, this.n);
        this.midCount = this.maxCount / 2L + 1L;
        this.reset();
    }

    public LocalNeighborhoodCursor2(RandomAccess<T> source, long[] center) {
        this(source, center, 1L);
    }

    protected LocalNeighborhoodCursor2(LocalNeighborhoodCursor2<T> c) {
        super(c.numDimensions());
        this.source = c.source.copyRandomAccess();
        this.center = c.center;
        this.max = (long[])c.max.clone();
        this.min = (long[])c.min.clone();
        this.span = c.span;
        this.maxCount = c.maxCount;
        this.midCount = c.midCount;
    }

    public T get() {
        return (T)this.source.get();
    }

    public void fwd() {
        this.source.fwd(0);
        if (this.source.getLongPosition(0) > this.max[0]) {
            this.source.setPosition(this.min[0], 0);
            for (int d = 1; d < this.n; ++d) {
                this.source.fwd(d);
                if (this.source.getLongPosition(d) <= this.max[d]) break;
                this.source.setPosition(this.min[d], d);
            }
        }
        if (++this.count == this.midCount) {
            this.fwd();
        }
    }

    public void reset() {
        for (int d = 0; d < this.n; ++d) {
            this.min[d] = this.center[d] - this.span;
            this.max[d] = this.center[d] + this.span;
        }
        this.source.setPosition(this.min);
        this.source.bck(0);
        this.count = 0L;
    }

    public boolean hasNext() {
        return this.count < this.maxCount;
    }

    public float getFloatPosition(int d) {
        return this.source.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.source.getDoublePosition(d);
    }

    public int getIntPosition(int d) {
        return this.source.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.source.getLongPosition(d);
    }

    public void localize(long[] position) {
        this.source.localize(position);
    }

    public void localize(float[] position) {
        this.source.localize(position);
    }

    public void localize(double[] position) {
        this.source.localize(position);
    }

    public void localize(int[] position) {
        this.source.localize(position);
    }

    public LocalNeighborhoodCursor2<T> copy() {
        return new LocalNeighborhoodCursor2<T>(this);
    }

    public LocalNeighborhoodCursor2<T> copyCursor() {
        return this.copy();
    }
}

