/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.Sampler;
import net.imglib2.algorithm.neighborhood.HorizontalLineNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.Neighborhood;

public abstract class HorizontalLineNeighborhoodLocalizableSampler<T>
extends AbstractEuclideanSpace
implements Localizable,
Sampler<Neighborhood<T>> {
    protected final RandomAccessible<T> source;
    protected final Interval sourceInterval;
    protected final long span;
    protected final int dim;
    protected final long[] currentPos;
    protected final HorizontalLineNeighborhoodFactory<T> neighborhoodFactory;
    protected final Neighborhood<T> currentNeighborhood;
    private final boolean skipCenter;

    public HorizontalLineNeighborhoodLocalizableSampler(RandomAccessible<T> source, long span, int dim, boolean skipCenter, HorizontalLineNeighborhoodFactory<T> factory, Interval accessInterval) {
        super(source.numDimensions());
        this.source = source;
        this.span = span;
        this.dim = dim;
        this.skipCenter = skipCenter;
        this.currentPos = new long[this.n];
        this.neighborhoodFactory = factory;
        if (accessInterval == null) {
            this.sourceInterval = null;
        } else {
            long[] accessMin = new long[this.n];
            long[] accessMax = new long[this.n];
            accessInterval.min(accessMin);
            accessInterval.max(accessMax);
            for (int d = 0; d < this.n; ++d) {
                accessMin[d] = this.currentPos[d] - span;
                accessMax[d] = this.currentPos[d] + span;
            }
            this.sourceInterval = new FinalInterval(accessMin, accessMax);
        }
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, span, dim, false, this.sourceInterval == null ? source.randomAccess() : source.randomAccess(this.sourceInterval));
    }

    protected HorizontalLineNeighborhoodLocalizableSampler(HorizontalLineNeighborhoodLocalizableSampler<T> c) {
        super(c.n);
        this.source = c.source;
        this.sourceInterval = c.sourceInterval;
        this.span = c.span;
        this.skipCenter = c.skipCenter;
        this.dim = c.dim;
        this.neighborhoodFactory = c.neighborhoodFactory;
        this.currentPos = (long[])c.currentPos.clone();
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, this.span, this.dim, this.skipCenter, this.source.randomAccess());
    }

    public Neighborhood<T> get() {
        return this.currentNeighborhood;
    }

    public void localize(int[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(long[] position) {
        this.currentNeighborhood.localize(position);
    }

    public int getIntPosition(int d) {
        return this.currentNeighborhood.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.currentNeighborhood.getLongPosition(d);
    }

    public void localize(float[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(double[] position) {
        this.currentNeighborhood.localize(position);
    }

    public float getFloatPosition(int d) {
        return this.currentNeighborhood.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.currentNeighborhood.getDoublePosition(d);
    }
}

