/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.Sampler;
import net.imglib2.algorithm.neighborhood.DiamondTipsNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.Neighborhood;

public abstract class DiamondTipsNeighborhoodLocalizableSampler<T>
extends AbstractEuclideanSpace
implements Localizable,
Sampler<Neighborhood<T>> {
    protected final RandomAccessible<T> source;
    protected final Interval sourceInterval;
    protected final long radius;
    protected final DiamondTipsNeighborhoodFactory<T> factory;
    protected final long[] currentPos;
    protected final Neighborhood<T> currentNeighborhood;

    public DiamondTipsNeighborhoodLocalizableSampler(RandomAccessible<T> source, long radius, DiamondTipsNeighborhoodFactory<T> factory, Interval accessInterval) {
        super(source.numDimensions());
        this.source = source;
        this.radius = radius;
        this.factory = factory;
        this.currentPos = new long[this.n];
        if (accessInterval == null) {
            this.sourceInterval = null;
        } else {
            long[] accessMin = new long[this.n];
            long[] accessMax = new long[this.n];
            accessInterval.min(accessMin);
            accessInterval.max(accessMax);
            for (int d = 0; d < this.n; ++d) {
                accessMin[d] = this.currentPos[d] - radius;
                accessMax[d] = this.currentPos[d] + radius;
            }
            this.sourceInterval = new FinalInterval(accessMin, accessMax);
        }
        this.currentNeighborhood = factory.create(this.currentPos, radius, this.sourceInterval == null ? source.randomAccess() : source.randomAccess(this.sourceInterval));
    }

    protected DiamondTipsNeighborhoodLocalizableSampler(DiamondTipsNeighborhoodLocalizableSampler<T> c) {
        super(c.n);
        this.source = c.source;
        this.sourceInterval = c.sourceInterval;
        this.radius = c.radius;
        this.factory = c.factory;
        this.currentPos = (long[])c.currentPos.clone();
        this.currentNeighborhood = this.factory.create(this.currentPos, this.radius, this.source.randomAccess());
    }

    public void localize(float[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(double[] position) {
        this.currentNeighborhood.localize(position);
    }

    public float getFloatPosition(int d) {
        return this.currentNeighborhood.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.currentNeighborhood.getDoublePosition(d);
    }

    public Neighborhood<T> get() {
        return this.currentNeighborhood;
    }

    public void localize(int[] position) {
        this.currentNeighborhood.localize(position);
    }

    public void localize(long[] position) {
        this.currentNeighborhood.localize(position);
    }

    public int getIntPosition(int d) {
        return this.currentNeighborhood.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.currentNeighborhood.getLongPosition(d);
    }
}

