/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.binary;

import java.util.Vector;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.converter.Converter;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;

public class Thresholder {
    public static final <T extends Type<T> & Comparable<T>> Img<BitType> threshold(final Img<T> source, T threshold, boolean above, int numThreads) {
        ImgFactory factory = source.factory();
        try {
            ImgFactory bitFactory = factory.imgFactory((Object)new BitType());
            final Img target = bitFactory.create(source, (Object)new BitType());
            Object converter = above ? new Converter<T, BitType>((Type)threshold){
                final /* synthetic */ Type val$threshold;
                {
                    this.val$threshold = type;
                }

                public void convert(T input, BitType output) {
                    output.set(((Comparable)input).compareTo(this.val$threshold) > 0);
                }
            } : new Converter<T, BitType>((Type)threshold){
                final /* synthetic */ Type val$threshold;
                {
                    this.val$threshold = type;
                }

                public void convert(T input, BitType output) {
                    output.set(((Comparable)input).compareTo(this.val$threshold) < 0);
                }
            };
            Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(target.size(), numThreads);
            Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
            if (target.iterationOrder().equals(source.iterationOrder())) {
                for (int i = 0; i < threads.length; ++i) {
                    final Chunk chunk = chunks.get(i);
                    threads[i] = new Thread("Thresholder thread " + i, (Converter)converter){
                        final /* synthetic */ Converter val$converter;
                        {
                            this.val$converter = converter;
                            super(x0);
                        }

                        @Override
                        public void run() {
                            Cursor cursorTarget = target.cursor();
                            cursorTarget.jumpFwd(chunk.getStartPosition());
                            Cursor cursorSource = source.cursor();
                            cursorSource.jumpFwd(chunk.getStartPosition());
                            for (long steps = 0L; steps < chunk.getLoopSize(); ++steps) {
                                cursorTarget.fwd();
                                cursorSource.fwd();
                                this.val$converter.convert(cursorSource.get(), cursorTarget.get());
                            }
                        }
                    };
                }
            } else {
                for (int i = 0; i < threads.length; ++i) {
                    final Chunk chunk = chunks.get(i);
                    threads[i] = new Thread("Thresholder thread " + i, (Converter)converter){
                        final /* synthetic */ Converter val$converter;
                        {
                            this.val$converter = converter;
                            super(x0);
                        }

                        @Override
                        public void run() {
                            Cursor cursorTarget = target.cursor();
                            cursorTarget.jumpFwd(chunk.getStartPosition());
                            RandomAccess ra = source.randomAccess((Interval)target);
                            for (long steps = 0L; steps < chunk.getLoopSize(); ++steps) {
                                cursorTarget.fwd();
                                ra.setPosition((Localizable)cursorTarget);
                                this.val$converter.convert(ra.get(), cursorTarget.get());
                            }
                        }
                    };
                }
            }
            SimpleMultiThreading.startAndJoin(threads);
            return target;
        }
        catch (IncompatibleTypeException e) {
            e.printStackTrace();
            return null;
        }
    }
}

