/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geometric;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.imglib2.AbstractCursor;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.KDTree;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RealLocalizable;
import net.imglib2.neighborsearch.NearestNeighborSearchOnKDTree;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.util.Contains;
import net.imglib2.roi.util.ContainsRandomAccess;
import net.imglib2.roi.util.ROIUtils;
import net.imglib2.type.logic.BoolType;

public class PointCollection
extends AbstractInterval
implements IterableRegion<BoolType> {
    private final Collection<? extends Localizable> vertices;
    private NearestNeighborSearchOnKDTree<? extends Localizable> search;

    public PointCollection(Collection<? extends Localizable> vertices) {
        super(ROIUtils.getBounds(vertices));
        this.vertices = vertices;
    }

    public Cursor<Void> cursor() {
        return new PointCollectionCursor(this.vertices);
    }

    public Cursor<Void> localizingCursor() {
        return this.cursor();
    }

    public long size() {
        return this.vertices.size();
    }

    public Void firstElement() {
        return null;
    }

    public Object iterationOrder() {
        return this;
    }

    public Iterator<Void> iterator() {
        return this.cursor();
    }

    public Collection<? extends Localizable> getVertices() {
        return this.vertices;
    }

    public RandomAccess<BoolType> randomAccess() {
        return new ContainsRandomAccess(new KDTreeContains());
    }

    public RandomAccess<BoolType> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    private synchronized <T extends Localizable> void initSearch(Collection<T> v) {
        if (this.search != null) {
            return;
        }
        ArrayList<T> vertexList = new ArrayList<T>(v);
        this.search = new NearestNeighborSearchOnKDTree(new KDTree(vertexList, vertexList));
    }

    private class KDTreeContains
    implements Contains<Localizable> {
        private final NearestNeighborSearchOnKDTree<? extends Localizable> s;

        public KDTreeContains() {
            if (PointCollection.this.search == null) {
                PointCollection.this.initSearch(PointCollection.this.vertices);
            }
            this.s = PointCollection.this.search.copy();
        }

        public int numDimensions() {
            return PointCollection.this.numDimensions();
        }

        @Override
        public boolean contains(Localizable o) {
            this.s.search((RealLocalizable)o);
            return this.s.getSquareDistance() < 0.5;
        }

        public KDTreeContains copyContains() {
            return new KDTreeContains();
        }
    }

    private static class PointCollectionCursor
    extends AbstractCursor<Void> {
        private final Collection<? extends Localizable> collection;
        private Iterator<? extends Localizable> currentIt;
        private Localizable currentPos;
        private int idx;

        public PointCollectionCursor(Collection<? extends Localizable> collection) {
            super(collection.iterator().next().numDimensions());
            this.collection = collection;
            this.reset();
        }

        private PointCollectionCursor(Collection<? extends Localizable> collection, int idx) {
            this(collection);
            this.jumpFwd(idx);
        }

        public Void get() {
            return null;
        }

        public void fwd() {
            ++this.idx;
            this.currentPos = this.currentIt.next();
        }

        public void reset() {
            this.currentIt = this.collection.iterator();
            this.idx = 0;
        }

        public boolean hasNext() {
            return this.currentIt.hasNext();
        }

        public void localize(long[] position) {
            this.currentPos.localize(position);
        }

        public long getLongPosition(int d) {
            return this.currentPos.getLongPosition(d);
        }

        public AbstractCursor<Void> copy() {
            return new PointCollectionCursor(this.collection, this.idx);
        }

        public AbstractCursor<Void> copyCursor() {
            return this.copy();
        }
    }
}

