/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import org.scijava.log.LogService;

public class SystemUtil {
    public static String getJavaBinary() {
        String jvm_location = System.getProperty("os.name").startsWith("Win") ? System.getProperties().getProperty("java.home") + File.separator + "bin" + File.separator + "java.exe" : System.getProperties().getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        return jvm_location;
    }

    public static String getImageJClassPaths() {
        String classPaths = "";
        if (System.getProperty("imagej.dir") != null) {
            classPaths = classPaths + Paths.get(System.getProperty("imagej.dir"), "jars", "*") + ":";
            classPaths = classPaths + Paths.get(System.getProperty("imagej.dir"), "jars", "bio-formats", "*") + ":";
            classPaths = classPaths + Paths.get(System.getProperty("imagej.dir"), "plugins", "*") + ":";
        }
        return classPaths;
    }

    public static void deleteFolderRecursively(Path rootPath, LogService log) {
        if (rootPath.toFile().exists()) {
            try {
                Files.walk(rootPath, FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException ex) {
                log.error(ex);
            }
        }
    }
}

