/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook.converter;

import net.imagej.notebook.ImageJNotebookService;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import org.scijava.convert.Converter;
import org.scijava.notebook.converter.NotebookOutputConverter;
import org.scijava.notebook.converter.ouput.PNGImageNotebookOutput;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class, priority=-100.0)
public class RAIToPNGNotebookConverter<O extends RandomAccessibleInterval>
extends NotebookOutputConverter<O, PNGImageNotebookOutput> {
    @Parameter
    private ImageJNotebookService ijnb;

    @Override
    public Class getInputType() {
        return RandomAccessibleInterval.class;
    }

    @Override
    public Class getOutputType() {
        return PNGImageNotebookOutput.class;
    }

    @Override
    public PNGImageNotebookOutput convert(Object object) {
        Img source = (Img)object;
        int cAxis = source.numDimensions() > 2 && source.dimension(2) <= 3L ? 2 : -1;
        String base64Image = (String)this.ijnb.RAIToPNG(source, 0, 1, cAxis, ImageJNotebookService.ValueScaling.AUTO, new long[0]);
        return new PNGImageNotebookOutput(PNGImageNotebookOutput.getMimeType(), base64Image);
    }
}

