/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook.converter;

import net.imagej.Dataset;
import net.imagej.axis.Axes;
import net.imagej.notebook.ImageJNotebookService;
import org.scijava.convert.Converter;
import org.scijava.notebook.converter.NotebookOutputConverter;
import org.scijava.notebook.converter.ouput.PNGImageNotebookOutput;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class, priority=-100.0)
public class DatasetToPNGNotebookConverter<O extends Dataset>
extends NotebookOutputConverter<O, PNGImageNotebookOutput> {
    @Parameter
    private ImageJNotebookService ijnb;

    @Override
    public Class getInputType() {
        return Dataset.class;
    }

    @Override
    public Class getOutputType() {
        return PNGImageNotebookOutput.class;
    }

    @Override
    public PNGImageNotebookOutput convert(Object object) {
        Dataset source = (Dataset)object;
        String base64Image = (String)this.ijnb.RAIToPNG(source, source.dimensionIndex(Axes.X), source.dimensionIndex(Axes.Y), source.dimensionIndex(Axes.CHANNEL), ImageJNotebookService.ValueScaling.AUTO, new long[0]);
        return new PNGImageNotebookOutput(PNGImageNotebookOutput.getMimeType(), base64Image);
    }
}

