/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.viewer.table;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.imagej.table.Table;
import net.imagej.table.TableDisplay;
import net.imagej.ui.viewer.table.TableDisplayPanel;
import org.scijava.ui.viewer.DisplayPanel;
import org.scijava.ui.viewer.DisplayWindow;

public class SwingTableDisplayPanel
extends JScrollPane
implements TableDisplayPanel {
    private final DisplayWindow window;
    private final TableDisplay display;
    private final JTable table;
    private final NullTableModel nullModel;

    public SwingTableDisplayPanel(TableDisplay display, DisplayWindow window) {
        this.display = display;
        this.window = window;
        this.nullModel = new NullTableModel();
        this.table = this.makeTable();
        this.table.setAutoCreateRowSorter(true);
        this.setViewportView(this.table);
        window.setContent((DisplayPanel)this);
    }

    public TableDisplay getDisplay() {
        return this.display;
    }

    public DisplayWindow getWindow() {
        return this.window;
    }

    public void redoLayout() {
    }

    public void setLabel(String s) {
    }

    public void redraw() {
        javax.swing.table.TableModel model = this.table.getModel();
        this.table.setModel(this.nullModel);
        this.table.setModel(model);
    }

    private JTable makeTable() {
        return new JTable(new TableModel(this.getTable()));
    }

    private Table<?, ?> getTable() {
        return this.display.size() == 0 ? null : (Table)this.display.get(0);
    }

    public static class TableModel
    extends AbstractTableModel {
        private final Table<?, ?> tab;

        public TableModel(Table<?, ?> table) {
            this.tab = table;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "";
            }
            return this.tab.getColumnHeader(col - 1);
        }

        @Override
        public int getRowCount() {
            return this.tab.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.tab.getColumnCount() + 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.getRowCount()) {
                return null;
            }
            if (col < 0 || col >= this.getColumnCount()) {
                return null;
            }
            if (col == 0) {
                String header = this.tab.getRowHeader(row);
                if (header != null) {
                    return header;
                }
                return "" + (row + 1);
            }
            return this.tab.get(col - 1, row);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row < 0 || row >= this.getRowCount()) {
                return;
            }
            if (col < 0 || col >= this.getColumnCount()) {
                return;
            }
            if (col == 0) {
                this.tab.setRowHeader(row, value == null ? null : value.toString());
                return;
            }
            this.set(this.tab, col - 1, row, value);
            this.fireTableCellUpdated(row, col);
        }

        private <T> void set(Table<?, T> table, int col, int row, Object value) {
            Object typedValue = value;
            table.set(col, row, typedValue);
        }
    }

    public static class NullTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return null;
        }
    }
}

