/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import net.imagej.Position;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayView;
import net.imagej.overlay.Overlay;
import net.imagej.ui.swing.overlay.AbstractJHotDrawAdapter;
import net.imagej.ui.swing.overlay.IJCreationTool;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import net.imglib2.RealRandomAccess;
import net.imglib2.roi.RegionOfInterest;
import net.imglib2.type.logic.BitType;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.ImageFigure;
import org.scijava.plugin.Plugin;
import org.scijava.tool.Tool;
import org.scijava.util.ColorRGB;

@Plugin(type=JHotDrawAdapter.class, priority=-10000.0)
public class DefaultJHotDrawAdapter
extends AbstractJHotDrawAdapter<Overlay, ImageFigure> {
    public static final double PRIORITY = -10000.0;

    @Override
    public boolean supports(Tool tool) {
        return false;
    }

    @Override
    public boolean supports(Overlay overlay, Figure figure) {
        return figure == null || figure instanceof ImageFigure;
    }

    @Override
    public Overlay createNewOverlay() {
        return null;
    }

    @Override
    public Figure createDefaultFigure() {
        ImageFigure figure = new ImageFigure();
        figure.setTransformable(false);
        this.initDefaultSettings(figure);
        return figure;
    }

    @Override
    public void updateFigure(OverlayView overlay, ImageFigure figure) {
        super.updateFigure(overlay, figure);
        figure.set(AttributeKeys.FILL_COLOR, (Object)new Color(0, 0, 0, 0));
        RegionOfInterest roi = overlay.getData().getRegionOfInterest();
        if (roi != null) {
            long minX = (long)Math.floor(roi.realMin(0));
            long maxX = (long)Math.ceil(roi.realMax(0)) + 1L;
            long minY = (long)Math.floor(roi.realMin(1));
            long maxY = (long)Math.ceil(roi.realMax(1)) + 1L;
            ColorRGB color = overlay.getData().getFillColor();
            IndexColorModel cm = new IndexColorModel(1, 2, new byte[]{0, (byte)color.getRed()}, new byte[]{0, (byte)color.getGreen()}, new byte[]{0, (byte)color.getBlue()}, new byte[]{0, (byte)overlay.getData().getAlpha()});
            int w = (int)(maxX - minX);
            int h = (int)(maxY - minY);
            BufferedImage img = new BufferedImage(w, h, 13, cm);
            SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(0, w, h, new int[]{1});
            DataBuffer dbuncast = ((SampleModel)sm).createDataBuffer();
            assert (dbuncast instanceof DataBufferByte);
            DataBufferByte db = (DataBufferByte)dbuncast;
            byte[] bankData = db.getData();
            RealRandomAccess ra = roi.realRandomAccess();
            Position planePos = overlay.getPlanePosition();
            for (int i = 0; i < planePos.numDimensions(); ++i) {
                long position = planePos.getLongPosition(i);
                ra.setPosition(position, i + 2);
            }
            int index = 0;
            for (int j = 0; j < h; ++j) {
                ra.setPosition(minY + (long)j, 1);
                for (int i = 0; i < w; ++i) {
                    ra.setPosition(minX + (long)i, 0);
                    if (((BitType)ra.get()).get()) {
                        bankData[index] = -1;
                    }
                    ++index;
                }
            }
            Raster raster = Raster.createRaster(sm, db, new Point(0, 0));
            img.setData(raster);
            figure.setBounds(new Rectangle2D.Double(minX, minY, w, h));
            figure.setBufferedImage(img);
        }
    }

    @Override
    public JHotDrawTool getCreationTool(ImageDisplay display) {
        return new IJCreationTool<ImageFigure>(display, this);
    }

    @Override
    public Shape toShape(ImageFigure figure) {
        throw new UnsupportedOperationException();
    }
}

