/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;
import org.scijava.ui.swing.widget.SpinnerNumberModelFactory;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.NumberWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingNumberWidget
extends SwingInputWidget<Number>
implements NumberWidget<JPanel>,
AdjustmentListener,
ChangeListener {
    @Parameter
    private ThreadService threadService;
    @Parameter
    private ModuleService moduleService;
    private JScrollBar scrollBar;
    private JSlider slider;
    private JSpinner spinner;

    public Number getValue() {
        return (Number)this.spinner.getValue();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        Number min = model.getMin();
        Number max = model.getMax();
        Number softMin = model.getSoftMin();
        Number softMax = model.getSoftMax();
        Number stepSize = model.getStepSize();
        if (model.isStyle("scroll bar")) {
            int smx = softMax.intValue();
            if (smx < Integer.MAX_VALUE) {
                ++smx;
            }
            this.scrollBar = new JScrollBar(0, softMin.intValue(), 1, softMin.intValue(), smx);
            this.scrollBar.setUnitIncrement(stepSize.intValue());
            this.setToolTip(this.scrollBar);
            this.getComponent().add(this.scrollBar);
            this.scrollBar.addAdjustmentListener(this);
        } else if (model.isStyle("slider")) {
            this.slider = new JSlider(softMin.intValue(), softMax.intValue(), softMin.intValue());
            this.slider.setMajorTickSpacing((softMax.intValue() - softMin.intValue()) / 4);
            this.slider.setMinorTickSpacing(stepSize.intValue());
            this.slider.setPaintLabels(true);
            this.slider.setPaintTicks(true);
            this.setToolTip(this.slider);
            this.getComponent().add(this.slider);
            this.slider.addChangeListener(this);
        }
        Class type = model.getItem().getType();
        Number value = (Number)model.getValue();
        SpinnerNumberModel spinnerModel = new SpinnerNumberModelFactory().createModel(value, min, max, stepSize);
        this.spinner = new JSpinner(spinnerModel);
        this.fixSpinner(type);
        this.setToolTip(this.spinner);
        this.getComponent().add(this.spinner);
        this.limitWidth(200);
        this.spinner.addChangeListener(this);
        this.refreshWidget();
        this.syncSliders();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isNumber();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        int value = this.scrollBar.getValue();
        this.spinner.setValue(value);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.slider) {
            int value = this.slider.getValue();
            this.spinner.setValue(value);
        } else if (source == this.spinner) {
            this.syncSliders();
        }
        this.updateModel();
    }

    private void limitWidth(int maxWidth) {
        Dimension minSize = this.spinner.getMinimumSize();
        if (minSize.width > maxWidth) {
            minSize.width = maxWidth;
            this.spinner.setMinimumSize(minSize);
        }
        Dimension prefSize = this.spinner.getPreferredSize();
        if (prefSize.width > maxWidth) {
            prefSize.width = maxWidth;
            this.spinner.setPreferredSize(prefSize);
        }
    }

    private void fixSpinner(Class<?> type) {
        this.fixSpinnerType(type);
        this.fixSpinnerFocus();
    }

    private void fixSpinnerType(Class<?> type) {
        if (!BigDecimal.class.isAssignableFrom(type) && !BigInteger.class.isAssignableFrom(type)) {
            return;
        }
        JComponent editor = this.spinner.getEditor();
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)editor;
        DecimalFormat decimalFormat = numberEditor.getFormat();
        decimalFormat.setParseBigDecimal(true);
    }

    private void fixSpinnerFocus() {
        for (Component c : this.spinner.getEditor().getComponents()) {
            if (!(c instanceof JTextField)) continue;
            final JTextField textField = (JTextField)c;
            textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.queueSelection();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.queueSelection();
                }

                private void queueSelection() {
                    SwingNumberWidget.this.threadService.queue(new Runnable(){

                        @Override
                        public void run() {
                            textField.selectAll();
                        }
                    });
                }
            });
        }
    }

    private void syncSliders() {
        int value;
        if (this.slider != null) {
            value = this.getValue().intValue();
            if (value < this.slider.getMinimum()) {
                value = this.slider.getMinimum();
            } else if (value > this.slider.getMaximum()) {
                value = this.slider.getMaximum();
            }
            this.slider.removeChangeListener(this);
            this.slider.setValue(value);
            this.slider.addChangeListener(this);
        }
        if (this.scrollBar != null) {
            value = this.getValue().intValue();
            if (value < this.scrollBar.getMinimum()) {
                value = this.scrollBar.getMinimum();
            } else if (value > this.scrollBar.getMaximum()) {
                value = this.scrollBar.getMaximum();
            }
            this.scrollBar.removeAdjustmentListener(this);
            this.scrollBar.setValue(this.getValue().intValue());
            this.scrollBar.addAdjustmentListener(this);
        }
    }

    public void doRefresh() {
        Object value = this.get().getValue();
        if (this.spinner.getValue().equals(value)) {
            return;
        }
        this.spinner.setValue(value);
    }
}

