/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import org.scijava.Context;
import org.scijava.console.OutputEvent;
import org.scijava.plugin.Parameter;
import org.scijava.thread.ThreadService;
import org.scijava.ui.console.AbstractConsolePane;
import org.scijava.ui.swing.StaticSwingUtils;

public class SwingConsolePane
extends AbstractConsolePane<JPanel> {
    @Parameter
    private ThreadService threadService;
    private JPanel consolePanel;
    private JTextPane textPane;
    private JScrollPane scrollPane;
    private StyledDocument doc;
    private Style stdoutLocal;
    private Style stderrLocal;
    private Style stdoutGlobal;
    private Style stderrGlobal;
    private Component window;

    public SwingConsolePane(Context context) {
        super(context);
    }

    public void setWindow(Component window) {
        this.window = window;
    }

    public JTextPane getTextPane() {
        if (this.consolePanel == null) {
            this.initConsolePanel();
        }
        return this.textPane;
    }

    public JScrollPane getScrollPane() {
        if (this.consolePanel == null) {
            this.initConsolePanel();
        }
        return this.scrollPane;
    }

    public void clear() {
        if (this.consolePanel == null) {
            this.initConsolePanel();
        }
        this.textPane.setText("");
    }

    public void append(final OutputEvent event) {
        if (this.consolePanel == null) {
            this.initConsolePanel();
        }
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                boolean atBottom = StaticSwingUtils.isScrolledToBottom(SwingConsolePane.this.scrollPane);
                try {
                    SwingConsolePane.this.doc.insertString(SwingConsolePane.this.doc.getLength(), event.getOutput(), SwingConsolePane.this.getStyle(event));
                }
                catch (BadLocationException exc) {
                    throw new RuntimeException(exc);
                }
                if (atBottom) {
                    StaticSwingUtils.scrollToBottom(SwingConsolePane.this.scrollPane);
                }
            }
        });
    }

    public void show() {
        if (this.window == null || this.window.isVisible()) {
            return;
        }
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                SwingConsolePane.this.window.setVisible(true);
            }
        });
    }

    public JPanel getComponent() {
        if (this.consolePanel == null) {
            this.initConsolePanel();
        }
        return this.consolePanel;
    }

    public Class<JPanel> getComponentType() {
        return JPanel.class;
    }

    private synchronized void initConsolePanel() {
        if (this.consolePanel != null) {
            return;
        }
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[grow,fill]", "[grow,fill,align top]"));
        this.textPane = new JTextPane();
        this.textPane.setFont(new Font("Monospaced", 0, 12));
        this.textPane.setEditable(false);
        this.doc = this.textPane.getStyledDocument();
        this.stdoutLocal = this.createStyle("stdoutLocal", null, Color.black, null, null);
        this.stderrLocal = this.createStyle("stderrLocal", null, Color.red, null, null);
        this.stdoutGlobal = this.createStyle("stdoutGlobal", this.stdoutLocal, null, null, true);
        this.stderrGlobal = this.createStyle("stderrGlobal", this.stderrLocal, null, null, true);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        textPanel.add(this.textPane);
        this.scrollPane = new JScrollPane(textPanel);
        this.scrollPane.setPreferredSize(new Dimension(600, 600));
        FontMetrics fm = this.scrollPane.getFontMetrics(this.scrollPane.getFont());
        int charWidth = fm.charWidth('a');
        int lineHeight = fm.getHeight();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(charWidth);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(2 * lineHeight);
        panel.add(this.scrollPane);
        this.consolePanel = panel;
    }

    private Style createStyle(String name, Style parent, Color foreground, Boolean bold, Boolean italic) {
        Style style = this.textPane.addStyle(name, parent);
        if (foreground != null) {
            StyleConstants.setForeground(style, foreground);
        }
        if (bold != null) {
            StyleConstants.setBold(style, bold);
        }
        if (italic != null) {
            StyleConstants.setItalic(style, italic);
        }
        return style;
    }

    private Style getStyle(OutputEvent event) {
        boolean stderr = event.getSource() == OutputEvent.Source.STDERR;
        boolean contextual = event.isContextual();
        if (stderr) {
            return contextual ? this.stderrLocal : this.stderrGlobal;
        }
        return contextual ? this.stdoutLocal : this.stdoutGlobal;
    }
}

