/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.color.ColorSpace;
import org.jhotdraw.color.NamedColorSpace;

public class HSVColorSpace
extends ColorSpace
implements NamedColorSpace {
    private static HSVColorSpace instance;

    public static HSVColorSpace getInstance() {
        if (instance == null) {
            instance = new HSVColorSpace();
        }
        return instance;
    }

    public HSVColorSpace() {
        super(7, 3);
    }

    @Override
    public float[] toRGB(float[] components) {
        float blue;
        float green;
        float red;
        float hue = components[0] * 360.0f;
        float saturation = components[1];
        float value = components[2];
        int hi = (int)(Math.floor(hue / 60.0f) % 6.0);
        float f = (float)((double)(hue / 60.0f) - Math.floor(hue / 60.0f));
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        switch (hi) {
            case 0: {
                red = value;
                green = t;
                blue = p;
                break;
            }
            case 1: {
                red = q;
                green = value;
                blue = p;
                break;
            }
            case 2: {
                red = p;
                green = value;
                blue = t;
                break;
            }
            case -3: 
            case 3: {
                red = p;
                green = q;
                blue = value;
                break;
            }
            case -2: 
            case 4: {
                red = t;
                green = p;
                blue = value;
                break;
            }
            case -1: 
            case 5: {
                red = value;
                green = p;
                blue = q;
                break;
            }
            default: {
                blue = 0.0f;
                green = 0.0f;
                red = 0.0f;
            }
        }
        return new float[]{red, green, blue};
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        float min;
        float r = rgbvalue[0];
        float g = rgbvalue[1];
        float b = rgbvalue[2];
        float max = Math.max(Math.max(r, g), b);
        float hue = max == (min = Math.min(Math.min(r, g), b)) ? 0.0f : (max == r && g >= b ? 60.0f * (g - b) / (max - min) : (max == r && g < b ? 60.0f * (g - b) / (max - min) + 360.0f : (max == g ? 60.0f * (b - r) / (max - min) + 120.0f : 60.0f * (r - g) / (max - min) + 240.0f)));
        float value = max;
        float saturation = max == 0.0f ? 0.0f : (max - min) / max;
        return new float[]{hue / 360.0f, saturation, value};
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        float[] rgb = this.toRGB(colorvalue);
        return ColorSpace.getInstance(1000).toCIEXYZ(rgb);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        float[] sRGB = ColorSpace.getInstance(1000).fromCIEXYZ(colorvalue);
        return this.fromRGB(sRGB);
    }

    @Override
    public String getName(int idx) {
        switch (idx) {
            case 0: {
                return "Hue";
            }
            case 1: {
                return "Saturation";
            }
            case 2: {
                return "Lightness";
            }
        }
        throw new IllegalArgumentException("index must be between 0 and 2:" + idx);
    }

    @Override
    public float getMaxValue(int component) {
        return 1.0f;
    }

    @Override
    public float getMinValue(int component) {
        return 0.0f;
    }

    public boolean equals(Object o) {
        return o instanceof HSVColorSpace;
    }

    public int hashCode() {
        return this.getClass().getSimpleName().hashCode();
    }

    @Override
    public String getName() {
        return "HSV";
    }
}

