/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingBuffer<T>
extends AbstractList<T> {
    protected static final IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException("RingBuffer index out of bounds");
    protected static final NoSuchElementException noSuchElementException = new NoSuchElementException("RingBuffer has no such element");
    protected static final IllegalStateException illegalStateException = new IllegalStateException("RingBuffer is in an illegal state");
    protected final T[] buffer;
    protected int nextRealIndex = 0;
    protected int size = 0;
    protected int nextBufferIndex = 0;

    public RingBuffer(int capacity) {
        this.buffer = new Object[capacity];
    }

    public boolean containsIndex(int index) {
        return !this.indexOutOfBounds(index);
    }

    protected boolean indexOutOfBounds(int index) {
        return index >= this.nextRealIndex || this.nextRealIndex - index - 1 >= this.size;
    }

    @Override
    public T get(int index) throws IndexOutOfBoundsException {
        if (this.indexOutOfBounds(index)) {
            throw new IndexOutOfBoundsException();
        }
        int bufferIndex = index % this.buffer.length;
        return this.buffer[bufferIndex];
    }

    @Override
    public boolean add(T element) {
        this.buffer[this.nextBufferIndex] = element;
        this.nextBufferIndex = ++this.nextRealIndex % this.buffer.length;
        this.size = Math.min(++this.size, this.buffer.length);
        return true;
    }

    @Override
    public void add(int index, T element) throws IndexOutOfBoundsException {
        if (index > this.nextRealIndex || this.nextRealIndex - index - 1 >= this.size) {
            throw indexOutOfBoundsException;
        }
        for (int k = this.nextRealIndex; k > index; --k) {
            this.buffer[k % this.buffer.length] = this.buffer[(k - 1) % this.buffer.length];
        }
        this.nextBufferIndex = ++this.nextRealIndex % this.buffer.length;
        this.size = Math.min(++this.size, this.buffer.length);
        this.buffer[index % this.buffer.length] = element;
    }

    protected T removeUnsafe(int index) {
        T element = this.buffer[index % this.buffer.length];
        for (int k = index + 1; k <= this.nextRealIndex; ++k) {
            this.buffer[(k - 1) % this.buffer.length] = this.buffer[k % this.buffer.length];
        }
        this.nextBufferIndex = Math.max(0, --this.nextRealIndex) % this.buffer.length;
        this.size = Math.min(Math.max(0, --this.size), this.buffer.length);
        return element;
    }

    @Override
    public T remove(int index) throws IndexOutOfBoundsException {
        if (this.indexOutOfBounds(index)) {
            throw indexOutOfBoundsException;
        }
        return this.removeUnsafe(index);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = null;
        }
        this.nextRealIndex = 0;
        this.nextBufferIndex = 0;
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new RingBufferIterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return new RingBufferListIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new RingBufferListIterator(index);
    }

    @Override
    public T[] toArray() {
        Object[] array = new Object[this.size];
        ListIterator<T> i = this.listIterator();
        int k = -1;
        while (i.hasNext()) {
            array[++k] = i.next();
        }
        return array;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int nextIndex() {
        return this.nextRealIndex;
    }

    public int lastIndex() {
        return this.nextRealIndex - 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RingBufferListIterator
    implements ListIterator<T> {
        protected int realIndex;
        protected int bufferIndex;
        protected int elementIndex;

        protected RingBufferListIterator() {
            this.realIndex = RingBuffer.this.nextRealIndex - RingBuffer.this.size;
            this.bufferIndex = this.realIndex % RingBuffer.this.buffer.length;
            this.elementIndex = -1;
        }

        protected RingBufferListIterator(int index) {
            if (RingBuffer.this.indexOutOfBounds(index)) {
                throw indexOutOfBoundsException;
            }
            this.realIndex = index;
            this.bufferIndex = this.realIndex % RingBuffer.this.buffer.length;
            this.elementIndex = -1;
        }

        @Override
        public int nextIndex() {
            return this.realIndex + 1;
        }

        @Override
        public int previousIndex() {
            return this.realIndex - 1;
        }

        @Override
        public boolean hasNext() {
            return this.realIndex < RingBuffer.this.nextRealIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this.realIndex > RingBuffer.this.nextRealIndex - RingBuffer.this.size;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw noSuchElementException;
            }
            this.elementIndex = this.bufferIndex;
            this.bufferIndex = ++this.realIndex % RingBuffer.this.buffer.length;
            return RingBuffer.this.buffer[this.elementIndex];
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw noSuchElementException;
            }
            this.elementIndex = this.bufferIndex = --this.realIndex % RingBuffer.this.buffer.length;
            return RingBuffer.this.buffer[this.elementIndex];
        }

        @Override
        public void add(T element) {
            RingBuffer.this.add(this.realIndex, element);
        }

        @Override
        public void remove() {
            if (this.elementIndex == -1) {
                throw illegalStateException;
            }
            RingBuffer.this.removeUnsafe(this.realIndex);
            this.bufferIndex = --this.realIndex % RingBuffer.this.buffer.length;
            this.elementIndex = -1;
        }

        @Override
        public void set(T element) {
            if (this.elementIndex == -1) {
                throw illegalStateException;
            }
            RingBuffer.this.buffer[this.elementIndex] = element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RingBufferIterator
    implements Iterator<T> {
        protected int index = 0;
        protected int elementIndex = -1;

        protected RingBufferIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < RingBuffer.this.size;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw noSuchElementException;
            }
            this.elementIndex = this.index++;
            return RingBuffer.this.buffer[this.elementIndex];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

